/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance3d;

import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.math.Plane3D;
import com.vividsolutions.jts.math.Vector3D;
import com.vividsolutions.jts.operation.distance3d.AxisPlaneCoordinateSequence;

public class PlanarPolygon3D {
    private int facingPlane = -1;
    private Plane3D plane;
    private Polygon poly;

    public PlanarPolygon3D(Polygon object) {
        this.poly = object;
        this.plane = object = this.findBestFitPlane((Polygon)object);
        this.facingPlane = ((Plane3D)object).closestAxisPlane();
    }

    private Vector3D averageNormal(CoordinateSequence coordinateSequence) {
        int n = coordinateSequence.size();
        Coordinate coordinate = new Coordinate(0.0, 0.0, 0.0);
        Coordinate coordinate2 = new Coordinate(0.0, 0.0, 0.0);
        Coordinate coordinate3 = new Coordinate(0.0, 0.0, 0.0);
        int n2 = 0;
        while (true) {
            if (n2 >= n - 1) {
                double d = coordinate.x;
                double d2 = n;
                coordinate.x = d / d2;
                coordinate.y /= d2;
                coordinate.z /= d2;
                return Vector3D.create(coordinate).normalize();
            }
            coordinateSequence.getCoordinate(n2, coordinate2);
            coordinateSequence.getCoordinate(++n2, coordinate3);
            coordinate.x += (coordinate2.y - coordinate3.y) * (coordinate2.z + coordinate3.z);
            coordinate.y += (coordinate2.z - coordinate3.z) * (coordinate2.x + coordinate3.x);
            coordinate.z += (coordinate2.x - coordinate3.x) * (coordinate2.y + coordinate3.y);
        }
    }

    private Coordinate averagePoint(CoordinateSequence coordinateSequence) {
        Coordinate coordinate = new Coordinate(0.0, 0.0, 0.0);
        int n = coordinateSequence.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                double d = coordinate.x;
                double d2 = n;
                coordinate.x = d / d2;
                coordinate.y /= d2;
                coordinate.z /= d2;
                return coordinate;
            }
            coordinate.x += coordinateSequence.getOrdinate(n2, 0);
            coordinate.y += coordinateSequence.getOrdinate(n2, 1);
            coordinate.z += coordinateSequence.getOrdinate(n2, 2);
            ++n2;
        }
    }

    private Plane3D findBestFitPlane(Polygon cloneable) {
        CoordinateSequence coordinateSequence = cloneable.getExteriorRing().getCoordinateSequence();
        cloneable = this.averagePoint(coordinateSequence);
        return new Plane3D(this.averageNormal(coordinateSequence), (Coordinate)cloneable);
    }

    private int locate(Coordinate coordinate, LineString cloneable) {
        cloneable = PlanarPolygon3D.project(cloneable.getCoordinateSequence(), this.facingPlane);
        return RayCrossingCounter.locatePointInRing(PlanarPolygon3D.project(coordinate, this.facingPlane), (CoordinateSequence)cloneable);
    }

    private static Coordinate project(Coordinate coordinate, int n) {
        if (n != 1) {
            if (n != 3) {
                return new Coordinate(coordinate.y, coordinate.z);
            }
            return new Coordinate(coordinate.x, coordinate.z);
        }
        return new Coordinate(coordinate.x, coordinate.y);
    }

    private static CoordinateSequence project(CoordinateSequence coordinateSequence, int n) {
        if (n != 1) {
            if (n != 3) {
                return AxisPlaneCoordinateSequence.projectToYZ(coordinateSequence);
            }
            return AxisPlaneCoordinateSequence.projectToXZ(coordinateSequence);
        }
        return AxisPlaneCoordinateSequence.projectToXY(coordinateSequence);
    }

    public Plane3D getPlane() {
        return this.plane;
    }

    public Polygon getPolygon() {
        return this.poly;
    }

    public boolean intersects(Coordinate coordinate) {
        if (2 == this.locate(coordinate, this.poly.getExteriorRing())) {
            return false;
        }
        int n = 0;
        while (n < this.poly.getNumInteriorRing()) {
            if (this.locate(coordinate, this.poly.getInteriorRingN(n)) == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean intersects(Coordinate coordinate, LineString cloneable) {
        cloneable = PlanarPolygon3D.project(cloneable.getCoordinateSequence(), this.facingPlane);
        return 2 != RayCrossingCounter.locatePointInRing(PlanarPolygon3D.project(coordinate, this.facingPlane), (CoordinateSequence)cloneable);
    }
}

