/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.linemerge;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.linemerge.EdgeString;
import com.vividsolutions.jts.operation.linemerge.LineMergeDirectedEdge;
import com.vividsolutions.jts.operation.linemerge.LineMergeGraph;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class LineMerger {
    private Collection edgeStrings = null;
    private GeometryFactory factory = null;
    private LineMergeGraph graph = new LineMergeGraph();
    private Collection mergedLineStrings = null;

    private void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
    }

    private EdgeString buildEdgeStringStartingWith(LineMergeDirectedEdge lineMergeDirectedEdge) {
        LineMergeDirectedEdge lineMergeDirectedEdge2;
        EdgeString edgeString = new EdgeString(this.factory);
        LineMergeDirectedEdge lineMergeDirectedEdge3 = lineMergeDirectedEdge;
        do {
            edgeString.add(lineMergeDirectedEdge3);
            lineMergeDirectedEdge3.getEdge().setMarked(true);
            lineMergeDirectedEdge2 = lineMergeDirectedEdge3.getNext();
            if (lineMergeDirectedEdge2 == null) break;
            lineMergeDirectedEdge3 = lineMergeDirectedEdge2;
        } while (lineMergeDirectedEdge2 != lineMergeDirectedEdge);
        return edgeString;
    }

    private void buildEdgeStringsForIsolatedLoops() {
        this.buildEdgeStringsForUnprocessedNodes();
    }

    private void buildEdgeStringsForNonDegree2Nodes() {
        Iterator iterator2 = this.graph.getNodes().iterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            if (node.getDegree() == 2) continue;
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
        return;
    }

    private void buildEdgeStringsForObviousStartNodes() {
        this.buildEdgeStringsForNonDegree2Nodes();
    }

    private void buildEdgeStringsForUnprocessedNodes() {
        Iterator iterator2 = this.graph.getNodes().iterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            if (node.isMarked()) continue;
            boolean bl = node.getDegree() == 2;
            Assert.isTrue(bl);
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
        return;
    }

    private void buildEdgeStringsStartingAt(Node object) {
        object = ((Node)object).getOutEdges().iterator();
        while (object.hasNext()) {
            LineMergeDirectedEdge lineMergeDirectedEdge = (LineMergeDirectedEdge)object.next();
            if (lineMergeDirectedEdge.getEdge().isMarked()) continue;
            this.edgeStrings.add(this.buildEdgeStringStartingWith(lineMergeDirectedEdge));
        }
        return;
    }

    private void merge() {
        if (this.mergedLineStrings != null) {
            return;
        }
        GraphComponent.setMarked(this.graph.nodeIterator(), false);
        GraphComponent.setMarked(this.graph.edgeIterator(), false);
        this.edgeStrings = new ArrayList();
        this.buildEdgeStringsForObviousStartNodes();
        this.buildEdgeStringsForIsolatedLoops();
        this.mergedLineStrings = new ArrayList();
        Iterator iterator2 = this.edgeStrings.iterator();
        while (iterator2.hasNext()) {
            EdgeString edgeString = (EdgeString)iterator2.next();
            this.mergedLineStrings.add(edgeString.toLineString());
        }
        return;
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geometry) {
                if (geometry instanceof LineString) {
                    LineMerger.this.add((LineString)geometry);
                }
            }
        });
    }

    public void add(Collection object) {
        this.mergedLineStrings = null;
        object = object.iterator();
        while (object.hasNext()) {
            this.add((Geometry)object.next());
        }
        return;
    }

    public Collection getMergedLineStrings() {
        this.merge();
        return this.mergedLineStrings;
    }
}

