/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LineBuilder {
    private GeometryFactory geometryFactory;
    private List lineEdgesList = new ArrayList();
    private OverlayOp op;
    private PointLocator ptLocator;
    private List resultLineList = new ArrayList();

    public LineBuilder(OverlayOp overlayOp, GeometryFactory geometryFactory, PointLocator pointLocator) {
        this.op = overlayOp;
        this.geometryFactory = geometryFactory;
        this.ptLocator = pointLocator;
    }

    private void buildLines(int n) {
        Iterator iterator2 = this.lineEdgesList.iterator();
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            edge.getLabel();
            LineString lineString = this.geometryFactory.createLineString(edge.getCoordinates());
            this.resultLineList.add(lineString);
            edge.setInResult(true);
        }
        return;
    }

    private void collectBoundaryTouchEdge(DirectedEdge directedEdge, int n, List list) {
        Label label = directedEdge.getLabel();
        if (directedEdge.isLineEdge()) {
            return;
        }
        if (directedEdge.isVisited()) {
            return;
        }
        if (directedEdge.isInteriorAreaEdge()) {
            return;
        }
        if (directedEdge.getEdge().isInResult()) {
            return;
        }
        boolean bl = !directedEdge.isInResult() && !directedEdge.getSym().isInResult() || !directedEdge.getEdge().isInResult();
        Assert.isTrue(bl);
        if (OverlayOp.isResultOfOp(label, n) && n == 1) {
            list.add(directedEdge.getEdge());
            directedEdge.setVisitedEdge(true);
        }
    }

    private void collectLineEdge(DirectedEdge directedEdge, int n, List list) {
        Label label = directedEdge.getLabel();
        Edge edge = directedEdge.getEdge();
        if (directedEdge.isLineEdge() && !directedEdge.isVisited() && OverlayOp.isResultOfOp(label, n) && !edge.isCovered()) {
            list.add(edge);
            directedEdge.setVisitedEdge(true);
        }
    }

    private void collectLines(int n) {
        Iterator iterator2 = this.op.getGraph().getEdgeEnds().iterator();
        while (iterator2.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator2.next();
            this.collectLineEdge(directedEdge, n, this.lineEdgesList);
            this.collectBoundaryTouchEdge(directedEdge, n, this.lineEdgesList);
        }
        return;
    }

    private void findCoveredLineEdges() {
        Iterator iterator2 = this.op.getGraph().getNodes().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                iterator2 = this.op.getGraph().getEdgeEnds().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        return;
                    }
                    DirectedEdge directedEdge = (DirectedEdge)iterator2.next();
                    Edge edge = directedEdge.getEdge();
                    if (!directedEdge.isLineEdge() || edge.isCoveredSet()) continue;
                    edge.setCovered(this.op.isCoveredByA(directedEdge.getCoordinate()));
                }
            }
            ((DirectedEdgeStar)((Node)iterator2.next()).getEdges()).findCoveredLineEdges();
        }
    }

    private void labelIsolatedLine(Edge edge, int n) {
        int n2 = this.ptLocator.locate(edge.getCoordinate(), this.op.getArgGeometry(n));
        edge.getLabel().setLocation(n, n2);
    }

    private void labelIsolatedLines(List object) {
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Edge edge = (Edge)iterator2.next();
            object = edge.getLabel();
            if (!edge.isIsolated()) continue;
            if (((Label)object).isNull(0)) {
                this.labelIsolatedLine(edge, 0);
                continue;
            }
            this.labelIsolatedLine(edge, 1);
        }
        return;
    }

    public List build(int n) {
        this.findCoveredLineEdges();
        this.collectLines(n);
        this.buildLines(n);
        return this.resultLineList;
    }
}

