/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geomgraph.Depth;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeList;
import com.vividsolutions.jts.geomgraph.EdgeNodingValidator;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.GeometryGraphOperation;
import com.vividsolutions.jts.operation.overlay.LineBuilder;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.operation.overlay.PointBuilder;
import com.vividsolutions.jts.operation.overlay.PolygonBuilder;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlayOp
extends GeometryGraphOperation {
    public static final int DIFFERENCE = 3;
    public static final int INTERSECTION = 1;
    public static final int SYMDIFFERENCE = 4;
    public static final int UNION = 2;
    private EdgeList edgeList;
    private GeometryFactory geomFact;
    private PlanarGraph graph;
    private final PointLocator ptLocator = new PointLocator();
    private Geometry resultGeom;
    private List resultLineList;
    private List resultPointList;
    private List resultPolyList;

    public OverlayOp(Geometry geometry, Geometry geometry2) {
        super(geometry, geometry2);
        this.edgeList = new EdgeList();
        this.resultPolyList = new ArrayList();
        this.resultLineList = new ArrayList();
        this.resultPointList = new ArrayList();
        this.graph = new PlanarGraph(new OverlayNodeFactory());
        this.geomFact = geometry.getFactory();
    }

    private void cancelDuplicateResultEdges() {
        Iterator iterator2 = this.graph.getEdgeEnds().iterator();
        while (iterator2.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator2.next();
            DirectedEdge directedEdge2 = directedEdge.getSym();
            if (!directedEdge.isInResult() || !directedEdge2.isInResult()) continue;
            directedEdge.setInResult(false);
            directedEdge2.setInResult(false);
        }
        return;
    }

    private Geometry computeGeometry(List list, List list2, List list3, int n) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        arrayList.addAll(list3);
        if (arrayList.isEmpty()) {
            return OverlayOp.createEmptyResult(n, this.arg[0].getGeometry(), this.arg[1].getGeometry(), this.geomFact);
        }
        return this.geomFact.buildGeometry(arrayList);
    }

    private void computeLabelling() {
        Iterator iterator2 = this.graph.getNodes().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                this.mergeSymLabels();
                this.updateNodeLabelling();
                return;
            }
            ((Node)iterator2.next()).getEdges().computeLabelling(this.arg);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void computeLabelsFromDepths() {
        var1_1 = this.edgeList.iterator();
        block0: while (true) {
            if (!var1_1.hasNext()) {
                return;
            }
            var2_2 = (Edge)var1_1.next();
            var3_3 = var2_2.getLabel();
            if ((var2_2 = var2_2.getDepth()).isNull()) continue;
            var2_2.normalize();
            var4_4 = 0;
            while (true) {
                if (var4_4 < 2) ** break;
                continue block0;
                if (!var3_3.isNull(var4_4) && var3_3.isArea() && !var2_2.isNull(var4_4)) {
                    if (var2_2.getDelta(var4_4) == 0) {
                        var3_3.toLine(var4_4);
                    } else {
                        Assert.isTrue(var2_2.isNull(var4_4, 1) ^ true, "depth of LEFT side has not been initialized");
                        var3_3.setLocation(var4_4, 1, var2_2.getLocation(var4_4, 1));
                        Assert.isTrue(true ^ var2_2.isNull(var4_4, 2), "depth of RIGHT side has not been initialized");
                        var3_3.setLocation(var4_4, 2, var2_2.getLocation(var4_4, 2));
                    }
                }
                ++var4_4;
            }
            break;
        }
    }

    private void computeOverlay(int n) {
        this.copyPoints(0);
        this.copyPoints(1);
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        this.arg[0].computeEdgeIntersections(this.arg[1], this.li, true);
        Object object = new ArrayList();
        this.arg[0].computeSplitEdges((List)object);
        this.arg[1].computeSplitEdges((List)object);
        this.insertUniqueEdges((List)object);
        this.computeLabelsFromDepths();
        this.replaceCollapsedEdges();
        EdgeNodingValidator.checkValid(this.edgeList.getEdges());
        this.graph.addEdges(this.edgeList.getEdges());
        this.computeLabelling();
        this.labelIncompleteNodes();
        this.findResultAreaEdges(n);
        this.cancelDuplicateResultEdges();
        object = new PolygonBuilder(this.geomFact);
        ((PolygonBuilder)object).add(this.graph);
        this.resultPolyList = ((PolygonBuilder)object).getPolygons();
        this.resultLineList = new LineBuilder(this, this.geomFact, this.ptLocator).build(n);
        this.resultPointList = object = new PointBuilder(this, this.geomFact, this.ptLocator).build(n);
        this.resultGeom = this.computeGeometry((List)object, this.resultLineList, this.resultPolyList, n);
    }

    private void copyPoints(int n) {
        Iterator iterator2 = this.arg[n].getNodeIterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            this.graph.addNode(node.getCoordinate()).setLabel(n, node.getLabel().getLocation(n));
        }
        return;
    }

    public static Geometry createEmptyResult(int n, Geometry geometry, Geometry geometry2, GeometryFactory geometryFactory) {
        n = OverlayOp.resultDimension(n, geometry, geometry2);
        geometry = null;
        if (n != -1) {
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        geometry = geometryFactory.createPolygon(null, null);
                    }
                } else {
                    geometry = geometryFactory.createLineString((Coordinate[])null);
                }
            } else {
                geometry = geometryFactory.createPoint((Coordinate)null);
            }
        } else {
            geometry = geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        return geometry;
    }

    private void findResultAreaEdges(int n) {
        Iterator iterator2 = this.graph.getEdgeEnds().iterator();
        while (iterator2.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator2.next();
            Label label = directedEdge.getLabel();
            if (!label.isArea() || directedEdge.isInteriorAreaEdge() || !OverlayOp.isResultOfOp(label.getLocation(0, 2), label.getLocation(1, 2), n)) continue;
            directedEdge.setInResult(true);
        }
        return;
    }

    private void insertUniqueEdges(List object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.insertUniqueEdge((Edge)object.next());
        }
        return;
    }

    private boolean isCovered(Coordinate coordinate, List object) {
        Geometry geometry;
        object = object.iterator();
        do {
            if (object.hasNext()) continue;
            return false;
        } while (this.ptLocator.locate(coordinate, geometry = (Geometry)object.next()) == 2);
        return true;
    }

    public static boolean isResultOfOp(int n, int n2, int n3) {
        int n4 = n;
        if (n == 1) {
            n4 = 0;
        }
        n = n2;
        if (n2 == 1) {
            n = 0;
        }
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) {
                    if (n3 != 4) {
                        return false;
                    }
                    return n4 == 0 && n != 0 || n4 != 0 && n == 0;
                    {
                    }
                }
                return n4 == 0 && n != 0;
            }
            return n4 == 0 || n == 0;
        }
        return n4 == 0 && n == 0;
    }

    public static boolean isResultOfOp(Label label, int n) {
        return OverlayOp.isResultOfOp(label.getLocation(0), label.getLocation(1), n);
    }

    private void labelIncompleteNode(Node node, int n) {
        int n2 = this.ptLocator.locate(node.getCoordinate(), this.arg[n].getGeometry());
        node.getLabel().setLocation(n, n2);
    }

    private void labelIncompleteNodes() {
        Iterator iterator2 = this.graph.getNodes().iterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            Label label = node.getLabel();
            if (node.isIsolated()) {
                if (label.isNull(0)) {
                    this.labelIncompleteNode(node, 0);
                } else {
                    this.labelIncompleteNode(node, 1);
                }
            }
            ((DirectedEdgeStar)node.getEdges()).updateLabelling(label);
        }
        return;
    }

    private void mergeSymLabels() {
        Iterator iterator2 = this.graph.getNodes().iterator();
        while (iterator2.hasNext()) {
            ((DirectedEdgeStar)((Node)iterator2.next()).getEdges()).mergeSymLabels();
        }
        return;
    }

    public static Geometry overlayOp(Geometry geometry, Geometry geometry2, int n) {
        return new OverlayOp(geometry, geometry2).getResultGeometry(n);
    }

    private void replaceCollapsedEdges() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Iterator iterator2 = this.edgeList.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                this.edgeList.addAll(arrayList);
                return;
            }
            Edge edge = (Edge)iterator2.next();
            if (!edge.isCollapsed()) continue;
            iterator2.remove();
            arrayList.add(edge.getCollapsedEdge());
        }
    }

    private static int resultDimension(int n, Geometry geometry, Geometry geometry2) {
        int n2;
        int n3 = geometry.getDimension();
        int n4 = geometry2.getDimension();
        if (n != 1) {
            if (n != 2) {
                n2 = n3;
                if (n != 3) {
                    n2 = n != 4 ? -1 : Math.max(n3, n4);
                }
            } else {
                n2 = Math.max(n3, n4);
            }
        } else {
            n2 = Math.min(n3, n4);
        }
        return n2;
    }

    private void updateNodeLabelling() {
        Iterator iterator2 = this.graph.getNodes().iterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            Label label = ((DirectedEdgeStar)node.getEdges()).getLabel();
            node.getLabel().merge(label);
        }
        return;
    }

    public PlanarGraph getGraph() {
        return this.graph;
    }

    public Geometry getResultGeometry(int n) {
        this.computeOverlay(n);
        return this.resultGeom;
    }

    protected void insertUniqueEdge(Edge object) {
        Edge edge = this.edgeList.findEqualEdge((Edge)object);
        if (edge != null) {
            Label label = edge.getLabel();
            Label label2 = ((GraphComponent)object).getLabel();
            if (!edge.isPointwiseEqual((Edge)object)) {
                label2 = new Label(((GraphComponent)object).getLabel());
                label2.flip();
            }
            if (((Depth)(object = edge.getDepth())).isNull()) {
                ((Depth)object).add(label);
            }
            ((Depth)object).add(label2);
            label.merge(label2);
        } else {
            this.edgeList.add((Edge)object);
        }
    }

    public boolean isCoveredByA(Coordinate coordinate) {
        return this.isCovered(coordinate, this.resultPolyList);
    }

    public boolean isCoveredByLA(Coordinate coordinate) {
        if (this.isCovered(coordinate, this.resultLineList)) {
            return true;
        }
        return this.isCovered(coordinate, this.resultPolyList);
    }
}

