/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PointBuilder {
    private GeometryFactory geometryFactory;
    private OverlayOp op;
    private List resultPointList = new ArrayList();

    public PointBuilder(OverlayOp overlayOp, GeometryFactory geometryFactory, PointLocator pointLocator) {
        this.op = overlayOp;
        this.geometryFactory = geometryFactory;
    }

    private void extractNonCoveredResultNodes(int n) {
        Iterator iterator2 = this.op.getGraph().getNodes().iterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            if (node.isInResult() || node.isIncidentEdgeInResult() || node.getEdges().getDegree() != 0 && n != 1 || !OverlayOp.isResultOfOp(node.getLabel(), n)) continue;
            this.filterCoveredNodeToPoint(node);
        }
        return;
    }

    private void filterCoveredNodeToPoint(Node object) {
        if (!this.op.isCoveredByLA((Coordinate)(object = ((Node)object).getCoordinate()))) {
            object = this.geometryFactory.createPoint((Coordinate)object);
            this.resultPointList.add(object);
        }
    }

    public List build(int n) {
        this.extractNonCoveredResultNodes(n);
        return this.resultPointList;
    }
}

