/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;

public class LineStringSnapper {
    private boolean allowSnappingToSourceVertices = false;
    private boolean isClosed = false;
    private LineSegment seg = new LineSegment();
    private double snapTolerance = 0.0;
    private Coordinate[] srcPts;

    public LineStringSnapper(LineString lineString, double d) {
        this(lineString.getCoordinates(), d);
    }

    public LineStringSnapper(Coordinate[] coordinateArray, double d) {
        this.srcPts = coordinateArray;
        this.isClosed = LineStringSnapper.isClosed(coordinateArray);
        this.snapTolerance = d;
    }

    private int findSegmentIndexToSnap(Coordinate coordinate, CoordinateList coordinateList) {
        double d = Double.MAX_VALUE;
        int n = 0;
        int n2 = -1;
        while (true) {
            int n3;
            double d2;
            if (n >= coordinateList.size() - 1) {
                return n2;
            }
            this.seg.p0 = (Coordinate)coordinateList.get(n);
            LineSegment lineSegment = this.seg;
            int n4 = n + 1;
            lineSegment.p1 = (Coordinate)coordinateList.get(n4);
            if (!this.seg.p0.equals2D(coordinate) && !this.seg.p1.equals2D(coordinate)) {
                double d3 = this.seg.distance(coordinate);
                d2 = d;
                n3 = n2;
                if (d3 < this.snapTolerance) {
                    d2 = d;
                    n3 = n2;
                    if (d3 < d) {
                        d2 = d3;
                        n3 = n;
                    }
                }
            } else {
                if (!this.allowSnappingToSourceVertices) break;
                n3 = n2;
                d2 = d;
            }
            n = n4;
            d = d2;
            n2 = n3;
        }
        return -1;
    }

    private Coordinate findSnapForVertex(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length) {
            if (coordinate.equals2D(coordinateArray[n])) {
                return null;
            }
            if (coordinate.distance(coordinateArray[n]) < this.snapTolerance) {
                return coordinateArray[n];
            }
            ++n;
        }
        return null;
    }

    private static boolean isClosed(Coordinate[] coordinateArray) {
        if (coordinateArray.length <= 1) {
            return false;
        }
        return coordinateArray[0].equals2D(coordinateArray[coordinateArray.length - 1]);
    }

    private void snapSegments(CoordinateList coordinateList, Coordinate[] coordinateArray) {
        if (coordinateArray.length == 0) {
            return;
        }
        int n = coordinateArray.length;
        if (coordinateArray[0].equals2D(coordinateArray[coordinateArray.length - 1])) {
            n = coordinateArray.length - 1;
        }
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray[n2];
            int n3 = this.findSegmentIndexToSnap(coordinate, coordinateList);
            if (n3 >= 0) {
                coordinateList.add(n3 + 1, new Coordinate(coordinate), false);
            }
            ++n2;
        }
        return;
    }

    private void snapVertices(CoordinateList coordinateList, Coordinate[] coordinateArray) {
        int n = this.isClosed ? coordinateList.size() - 1 : coordinateList.size();
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = this.findSnapForVertex((Coordinate)coordinateList.get(n2), coordinateArray);
            if (coordinate != null) {
                coordinateList.set(n2, new Coordinate(coordinate));
                if (n2 == 0 && this.isClosed) {
                    coordinateList.set(coordinateList.size() - 1, new Coordinate(coordinate));
                }
            }
            ++n2;
        }
        return;
    }

    public void setAllowSnappingToSourceVertices(boolean bl) {
        this.allowSnappingToSourceVertices = bl;
    }

    public Coordinate[] snapTo(Coordinate[] coordinateArray) {
        CoordinateList coordinateList = new CoordinateList(this.srcPts);
        this.snapVertices(coordinateList, coordinateArray);
        this.snapSegments(coordinateList, coordinateArray);
        return coordinateList.toCoordinateArray();
    }
}

