/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.validate;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.operation.overlay.validate.PolygonalLineworkExtracter;

public class FuzzyPointLocator {
    private double boundaryDistanceTolerance;
    private Geometry g;
    private MultiLineString linework;
    private PointLocator ptLocator = new PointLocator();
    private LineSegment seg = new LineSegment();

    public FuzzyPointLocator(Geometry geometry, double d) {
        this.g = geometry;
        this.boundaryDistanceTolerance = d;
        this.linework = this.extractLinework(geometry);
    }

    private MultiLineString extractLinework(Geometry geometry) {
        LineString[] lineStringArray = new PolygonalLineworkExtracter();
        geometry.apply((GeometryFilter)lineStringArray);
        lineStringArray = GeometryFactory.toLineStringArray(lineStringArray.getLinework());
        return geometry.getFactory().createMultiLineString(lineStringArray);
    }

    private boolean isWithinToleranceOfBoundary(Coordinate coordinate) {
        int n = 0;
        block0: while (true) {
            if (n >= this.linework.getNumGeometries()) {
                return false;
            }
            CoordinateSequence coordinateSequence = ((LineString)this.linework.getGeometryN(n)).getCoordinateSequence();
            int n2 = 0;
            do {
                if (n2 >= coordinateSequence.size() - 1) {
                    ++n;
                    continue block0;
                }
                coordinateSequence.getCoordinate(n2, this.seg.p0);
                coordinateSequence.getCoordinate(++n2, this.seg.p1);
            } while (!(this.seg.distance(coordinate) <= this.boundaryDistanceTolerance));
            break;
        }
        return true;
    }

    public int getLocation(Coordinate coordinate) {
        if (this.isWithinToleranceOfBoundary(coordinate)) {
            return 1;
        }
        return this.ptLocator.locate(coordinate, this.g);
    }
}

