/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OffsetPointGenerator {
    private boolean doLeft = true;
    private boolean doRight = true;
    private Geometry g;

    public OffsetPointGenerator(Geometry geometry) {
        this.g = geometry;
    }

    private void computeOffsetPoints(Coordinate coordinate, Coordinate coordinate2, double d, List list) {
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate2.y - coordinate.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        d2 = d2 * d / d4;
        d4 = d * d3 / d4;
        d = (coordinate2.x + coordinate.x) / 2.0;
        d3 = (coordinate2.y + coordinate.y) / 2.0;
        if (this.doLeft) {
            list.add(new Coordinate(d - d4, d3 + d2));
        }
        if (this.doRight) {
            list.add(new Coordinate(d + d4, d3 - d2));
        }
    }

    private void extractPoints(LineString coordinateArray, double d, List list) {
        coordinateArray = coordinateArray.getCoordinates();
        int n = 0;
        while (n < coordinateArray.length - 1) {
            Coordinate coordinate = coordinateArray[n];
            this.computeOffsetPoints(coordinate, coordinateArray[++n], d, list);
        }
        return;
    }

    public List getPoints(double d) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator2 = LinearComponentExtracter.getLines(this.g).iterator();
        while (iterator2.hasNext()) {
            this.extractPoints((LineString)iterator2.next(), d, arrayList);
        }
        return arrayList;
    }

    public void setSidesToGenerate(boolean bl, boolean bl2) {
        this.doLeft = bl;
        this.doRight = bl2;
    }
}

