/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Location;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.operation.overlay.snap.GeometrySnapper;
import com.vividsolutions.jts.operation.overlay.validate.FuzzyPointLocator;
import com.vividsolutions.jts.operation.overlay.validate.OffsetPointGenerator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class OverlayResultValidator {
    private static final double TOLERANCE = 1.0E-6;
    private double boundaryDistanceTolerance = 1.0E-6;
    private Geometry[] geom;
    private Coordinate invalidLocation = null;
    private FuzzyPointLocator[] locFinder;
    private int[] location = new int[3];
    private List testCoords = new ArrayList();

    public OverlayResultValidator(Geometry geometry, Geometry geometry2, Geometry geometry3) {
        double d;
        this.boundaryDistanceTolerance = d = OverlayResultValidator.computeBoundaryDistanceTolerance(geometry, geometry2);
        Geometry[] geometryArray = new Geometry[]{geometry, geometry2, geometry3};
        this.geom = geometryArray;
        this.locFinder = new FuzzyPointLocator[]{new FuzzyPointLocator(geometryArray[0], d), new FuzzyPointLocator(this.geom[1], this.boundaryDistanceTolerance), new FuzzyPointLocator(this.geom[2], this.boundaryDistanceTolerance)};
    }

    private void addTestPts(Geometry object) {
        object = new OffsetPointGenerator((Geometry)object);
        this.testCoords.addAll(((OffsetPointGenerator)object).getPoints(this.boundaryDistanceTolerance * 5.0));
    }

    private boolean checkValid(int n) {
        int n2 = 0;
        while (n2 < this.testCoords.size()) {
            Coordinate coordinate = (Coordinate)this.testCoords.get(n2);
            if (!this.checkValid(n, coordinate)) {
                this.invalidLocation = coordinate;
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean checkValid(int n, Coordinate coordinate) {
        this.location[0] = this.locFinder[0].getLocation(coordinate);
        this.location[1] = this.locFinder[1].getLocation(coordinate);
        this.location[2] = this.locFinder[2].getLocation(coordinate);
        if (OverlayResultValidator.hasLocation(this.location, 1)) {
            return true;
        }
        return this.isValidResult(n, this.location);
    }

    private static double computeBoundaryDistanceTolerance(Geometry geometry, Geometry geometry2) {
        return Math.min(GeometrySnapper.computeSizeBasedSnapTolerance(geometry), GeometrySnapper.computeSizeBasedSnapTolerance(geometry2));
    }

    private static boolean hasLocation(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < 3) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isValid(Geometry geometry, Geometry geometry2, int n, Geometry geometry3) {
        return new OverlayResultValidator(geometry, geometry2, geometry3).isValid(n);
    }

    private boolean isValidResult(int n, int[] nArray) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = OverlayOp.isResultOfOp(nArray[0], nArray[1], n);
        if (nArray[2] == 0) {
            bl2 = true;
        }
        if (!(bl = bl2 ^ bl3 ^ true)) {
            this.reportResult(n, nArray, bl3);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void reportResult(int n, int[] nArray, boolean bl) {
        void var6_8;
        PrintStream printStream = System.out;
        StringBuilder stringBuilder = new StringBuilder("Overlay result invalid - A:");
        stringBuilder.append(Location.toLocationSymbol(nArray[0]));
        stringBuilder.append(" B:");
        stringBuilder.append(Location.toLocationSymbol(nArray[1]));
        stringBuilder.append(" expected:");
        if (bl) {
            int c = n = 105;
        } else {
            int n2 = n = 101;
        }
        stringBuilder.append((char)var6_8);
        stringBuilder.append(" actual:");
        stringBuilder.append(Location.toLocationSymbol(nArray[2]));
        printStream.println(stringBuilder.toString());
    }

    public Coordinate getInvalidLocation() {
        return this.invalidLocation;
    }

    public boolean isValid(int n) {
        this.addTestPts(this.geom[0]);
        this.addTestPts(this.geom[1]);
        return this.checkValid(n);
    }
}

