/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.algorithm.locate.SimplePointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;

class GeometryContainsPointVisitor
extends ShortCircuitedGeometryVisitor {
    private boolean containsPoint = false;
    private Envelope rectEnv;
    private CoordinateSequence rectSeq;

    public GeometryContainsPointVisitor(Polygon polygon) {
        this.rectSeq = polygon.getExteriorRing().getCoordinateSequence();
        this.rectEnv = polygon.getEnvelopeInternal();
    }

    public boolean containsPoint() {
        return this.containsPoint;
    }

    @Override
    protected boolean isDone() {
        return this.containsPoint;
    }

    @Override
    protected void visit(Geometry geometry) {
        if (!(geometry instanceof Polygon)) {
            return;
        }
        Envelope envelope = geometry.getEnvelopeInternal();
        if (!this.rectEnv.intersects(envelope)) {
            return;
        }
        Coordinate coordinate = new Coordinate();
        int n = 0;
        while (n < 4) {
            this.rectSeq.getCoordinate(n, coordinate);
            if (envelope.contains(coordinate) && SimplePointInAreaLocator.containsPointInPolygon(coordinate, (Polygon)geometry)) {
                this.containsPoint = true;
                return;
            }
            ++n;
        }
        return;
    }
}

