/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class RectangleContains {
    private Envelope rectEnv;

    public RectangleContains(Polygon polygon) {
        this.rectEnv = polygon.getEnvelopeInternal();
    }

    public static boolean contains(Polygon polygon, Geometry geometry) {
        return new RectangleContains(polygon).contains(geometry);
    }

    private boolean isContainedInBoundary(Geometry geometry) {
        if (geometry instanceof Polygon) {
            return false;
        }
        if (geometry instanceof Point) {
            return this.isPointContainedInBoundary((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return this.isLineStringContainedInBoundary((LineString)geometry);
        }
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            if (!this.isContainedInBoundary(geometry.getGeometryN(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isLineSegmentContainedInBoundary(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate.equals(coordinate2)) {
            return this.isPointContainedInBoundary(coordinate);
        }
        return coordinate.x == coordinate2.x ? coordinate.x == this.rectEnv.getMinX() || coordinate.x == this.rectEnv.getMaxX() : coordinate.y == coordinate2.y && (coordinate.y == this.rectEnv.getMinY() || coordinate.y == this.rectEnv.getMaxY());
    }

    private boolean isLineStringContainedInBoundary(LineString cloneable) {
        CoordinateSequence coordinateSequence = cloneable.getCoordinateSequence();
        Coordinate coordinate = new Coordinate();
        cloneable = new Coordinate();
        int n = 0;
        do {
            if (n >= coordinateSequence.size() - 1) {
                return true;
            }
            coordinateSequence.getCoordinate(n, coordinate);
            coordinateSequence.getCoordinate(++n, (Coordinate)cloneable);
        } while (this.isLineSegmentContainedInBoundary(coordinate, (Coordinate)cloneable));
        return false;
    }

    private boolean isPointContainedInBoundary(Coordinate coordinate) {
        return coordinate.x == this.rectEnv.getMinX() || coordinate.x == this.rectEnv.getMaxX() || coordinate.y == this.rectEnv.getMinY() || coordinate.y == this.rectEnv.getMaxY();
    }

    private boolean isPointContainedInBoundary(Point point) {
        return this.isPointContainedInBoundary(point.getCoordinate());
    }

    public boolean contains(Geometry geometry) {
        if (!this.rectEnv.contains(geometry.getEnvelopeInternal())) {
            return false;
        }
        return !this.isContainedInBoundary(geometry);
    }
}

