/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.algorithm.RectangleLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;
import java.util.List;

class RectangleIntersectsSegmentVisitor
extends ShortCircuitedGeometryVisitor {
    private boolean hasIntersection = false;
    private Coordinate p0 = new Coordinate();
    private Coordinate p1 = new Coordinate();
    private Envelope rectEnv;
    private RectangleLineIntersector rectIntersector;

    public RectangleIntersectsSegmentVisitor(Polygon comparable) {
        comparable = comparable.getEnvelopeInternal();
        this.rectEnv = comparable;
        this.rectIntersector = new RectangleLineIntersector((Envelope)comparable);
    }

    private void checkIntersectionWithLineStrings(List object) {
        object = object.iterator();
        do {
            if (!object.hasNext()) {
                return;
            }
            this.checkIntersectionWithSegments((LineString)object.next());
        } while (!this.hasIntersection);
    }

    private void checkIntersectionWithSegments(LineString cloneable) {
        cloneable = ((LineString)cloneable).getCoordinateSequence();
        int n = 1;
        while (n < cloneable.size()) {
            cloneable.getCoordinate(n - 1, this.p0);
            cloneable.getCoordinate(n, this.p1);
            if (this.rectIntersector.intersects(this.p0, this.p1)) {
                this.hasIntersection = true;
                return;
            }
            ++n;
        }
        return;
    }

    public boolean intersects() {
        return this.hasIntersection;
    }

    @Override
    protected boolean isDone() {
        return this.hasIntersection;
    }

    @Override
    protected void visit(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        if (!this.rectEnv.intersects(envelope)) {
            return;
        }
        this.checkIntersectionWithLineStrings(LinearComponentExtracter.getLines(geometry));
    }
}

