/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Label;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EdgeEndBundle
extends EdgeEnd {
    private List edgeEnds = new ArrayList();

    public EdgeEndBundle(BoundaryNodeRule boundaryNodeRule, EdgeEnd edgeEnd) {
        super(edgeEnd.getEdge(), edgeEnd.getCoordinate(), edgeEnd.getDirectedCoordinate(), new Label(edgeEnd.getLabel()));
        this.insert(edgeEnd);
    }

    public EdgeEndBundle(EdgeEnd edgeEnd) {
        this(null, edgeEnd);
    }

    private void computeLabelOn(int n, BoundaryNodeRule boundaryNodeRule) {
        Iterator iterator2 = this.iterator();
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (true) {
            int n4;
            if (!iterator2.hasNext()) {
                n4 = bl ? n2 : -1;
                if (n3 > 0) {
                    n4 = GeometryGraph.determineBoundary(boundaryNodeRule, n3);
                }
                this.label.setLocation(n, n4);
                return;
            }
            int n5 = ((EdgeEnd)iterator2.next()).getLabel().getLocation(n);
            n4 = n3;
            if (n5 == 1) {
                n4 = n3 + 1;
            }
            n3 = n4;
            if (n5 != 0) continue;
            bl = true;
            n3 = n4;
        }
    }

    private void computeLabelSide(int n, int n2) {
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator2.next();
            if (!edgeEnd.getLabel().isArea()) continue;
            int n3 = edgeEnd.getLabel().getLocation(n, n2);
            if (n3 == 0) {
                this.label.setLocation(n, n2, 0);
                return;
            }
            if (n3 != 2) continue;
            this.label.setLocation(n, n2, 2);
        }
        return;
    }

    private void computeLabelSides(int n) {
        this.computeLabelSide(n, 1);
        this.computeLabelSide(n, 2);
    }

    @Override
    public void computeLabel(BoundaryNodeRule boundaryNodeRule) {
        Iterator iterator2 = this.iterator();
        int n = 0;
        boolean bl = false;
        while (true) {
            if (!iterator2.hasNext()) {
                this.label = bl ? new Label(-1, -1, -1) : new Label(-1);
                while (true) {
                    if (n >= 2) {
                        return;
                    }
                    this.computeLabelOn(n, boundaryNodeRule);
                    if (bl) {
                        this.computeLabelSides(n);
                    }
                    ++n;
                }
            }
            if (!((EdgeEnd)iterator2.next()).getLabel().isArea()) continue;
            bl = true;
        }
    }

    public List getEdgeEnds() {
        return this.edgeEnds;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    public void insert(EdgeEnd edgeEnd) {
        this.edgeEnds.add(edgeEnd);
    }

    public Iterator iterator() {
        return this.edgeEnds.iterator();
    }

    @Override
    public void print(PrintStream printStream) {
        Object object = new StringBuilder("EdgeEndBundle--> Label: ");
        ((StringBuilder)object).append(this.label);
        printStream.println(((StringBuilder)object).toString());
        object = this.iterator();
        while (object.hasNext()) {
            ((EdgeEnd)object.next()).print(printStream);
            printStream.println();
        }
        return;
    }

    void updateIM(IntersectionMatrix intersectionMatrix) {
        Edge.updateIM(this.label, intersectionMatrix);
    }
}

