/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.union;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.util.GeometryCombiner;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.index.strtree.AbstractSTRtree;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CascadedPolygonUnion {
    private static final int STRTREE_NODE_CAPACITY = 4;
    private GeometryFactory geomFactory = null;
    private Collection inputPolys;

    public CascadedPolygonUnion(Collection collection) {
        this.inputPolys = collection;
        if (collection == null) {
            this.inputPolys = new ArrayList();
        }
    }

    private Geometry binaryUnion(List list) {
        return this.binaryUnion(list, 0, list.size());
    }

    private Geometry binaryUnion(List list, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 1) {
            return this.unionSafe(CascadedPolygonUnion.getGeometry(list, n), null);
        }
        if (n3 == 2) {
            return this.unionSafe(CascadedPolygonUnion.getGeometry(list, n), CascadedPolygonUnion.getGeometry(list, n + 1));
        }
        n3 = (n2 + n) / 2;
        return this.unionSafe(this.binaryUnion(list, n, n3), this.binaryUnion(list, n3, n2));
    }

    private Geometry bufferUnion(Geometry geometry, Geometry geometry2) {
        return geometry.getFactory().createGeometryCollection(new Geometry[]{geometry, geometry2}).buffer(0.0);
    }

    private Geometry bufferUnion(List list) {
        return ((Geometry)list.get(0)).getFactory().buildGeometry(list).buffer(0.0);
    }

    private Geometry extractByEnvelope(Envelope envelope, Geometry geometry, List list) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            Geometry geometry2 = geometry.getGeometryN(n);
            if (geometry2.getEnvelopeInternal().intersects(envelope)) {
                arrayList.add(geometry2);
            } else {
                list.add(geometry2);
            }
            ++n;
        }
        return this.geomFactory.buildGeometry(arrayList);
    }

    private static Geometry getGeometry(List list, int n) {
        if (n >= list.size()) {
            return null;
        }
        return (Geometry)list.get(n);
    }

    private List reduceToGeometries(List object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            object = null;
            if (e instanceof List) {
                object = this.unionTree((List)e);
            } else if (e instanceof Geometry) {
                object = (Geometry)e;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private Geometry repeatedUnion(List object) {
        Iterator iterator2 = object.iterator();
        object = null;
        while (iterator2.hasNext()) {
            Geometry geometry = (Geometry)iterator2.next();
            if (object == null) {
                object = (Geometry)geometry.clone();
                continue;
            }
            object = ((Geometry)object).union(geometry);
        }
        return object;
    }

    private static Geometry restrictToPolygons(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            return geometry;
        }
        List list = PolygonExtracter.getPolygons(geometry);
        if (list.size() == 1) {
            return (Polygon)list.get(0);
        }
        return geometry.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray(list));
    }

    public static Geometry union(Collection collection) {
        return new CascadedPolygonUnion(collection).union();
    }

    private Geometry unionActual(Geometry geometry, Geometry geometry2) {
        return CascadedPolygonUnion.restrictToPolygons(geometry.union(geometry2));
    }

    private Geometry unionOptimized(Geometry geometry, Geometry geometry2) {
        Envelope envelope;
        Envelope envelope2 = geometry.getEnvelopeInternal();
        if (!envelope2.intersects(envelope = geometry2.getEnvelopeInternal())) {
            return GeometryCombiner.combine(geometry, geometry2);
        }
        if (geometry.getNumGeometries() <= 1 && geometry2.getNumGeometries() <= 1) {
            return this.unionActual(geometry, geometry2);
        }
        return this.unionUsingEnvelopeIntersection(geometry, geometry2, envelope2.intersection(envelope));
    }

    private Geometry unionSafe(Geometry geometry, Geometry geometry2) {
        if (geometry == null && geometry2 == null) {
            return null;
        }
        if (geometry == null) {
            return (Geometry)geometry2.clone();
        }
        if (geometry2 == null) {
            return (Geometry)geometry.clone();
        }
        return this.unionOptimized(geometry, geometry2);
    }

    private Geometry unionTree(List list) {
        return this.binaryUnion(this.reduceToGeometries(list));
    }

    private Geometry unionUsingEnvelopeIntersection(Geometry geometry, Geometry geometry2, Envelope envelope) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        arrayList.add(this.unionActual(this.extractByEnvelope(envelope, geometry, arrayList), this.extractByEnvelope(envelope, geometry2, arrayList)));
        return GeometryCombiner.combine(arrayList);
    }

    public Geometry union() {
        Object object = this.inputPolys;
        if (object != null) {
            if (object.isEmpty()) {
                return null;
            }
            this.geomFactory = ((Geometry)this.inputPolys.iterator().next()).getFactory();
            object = new STRtree(4);
            Iterator iterator2 = this.inputPolys.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    this.inputPolys = null;
                    return this.unionTree(((AbstractSTRtree)object).itemsTree());
                }
                Geometry geometry = (Geometry)iterator2.next();
                ((STRtree)object).insert(geometry.getEnvelopeInternal(), (Object)geometry);
            }
        }
        throw new IllegalStateException("union() method cannot be called twice");
    }
}

