/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.union;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.util.GeometryCombiner;
import java.util.TreeSet;

public class PointGeometryUnion {
    private GeometryFactory geomFact;
    private Geometry otherGeom;
    private Geometry pointGeom;

    public PointGeometryUnion(Puntal puntal, Geometry geometry) {
        this.pointGeom = (Geometry)((Object)puntal);
        this.otherGeom = geometry;
        this.geomFact = geometry.getFactory();
    }

    public static Geometry union(Puntal puntal, Geometry geometry) {
        return new PointGeometryUnion(puntal, geometry).union();
    }

    public Geometry union() {
        PointLocator pointLocator = new PointLocator();
        TreeSet<Coordinate[]> treeSet = new TreeSet<Coordinate[]>();
        int n = 0;
        while (true) {
            Object object;
            if (n >= this.pointGeom.getNumGeometries()) {
                if (treeSet.size() == 0) {
                    return this.otherGeom;
                }
                object = CoordinateArrays.toCoordinateArray(treeSet);
                object = ((Coordinate[])object).length == 1 ? this.geomFact.createPoint(object[0]) : this.geomFact.createMultiPoint((Coordinate[])object);
                return GeometryCombiner.combine((Geometry)object, this.otherGeom);
            }
            object = ((Point)this.pointGeom.getGeometryN(n)).getCoordinate();
            if (pointLocator.locate((Coordinate)object, this.otherGeom) == 2) {
                treeSet.add((Coordinate[])object);
            }
            ++n;
        }
    }
}

