/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.union;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.util.GeometryCombiner;
import java.util.ArrayList;

public class UnionInteracting {
    private Geometry g0;
    private Geometry g1;
    private GeometryFactory geomFactory;
    private boolean[] interacts0;
    private boolean[] interacts1;

    public UnionInteracting(Geometry geometry, Geometry geometry2) {
        this.g0 = geometry;
        this.g1 = geometry2;
        this.geomFactory = geometry.getFactory();
        this.interacts0 = new boolean[geometry.getNumGeometries()];
        this.interacts1 = new boolean[geometry2.getNumGeometries()];
    }

    private Geometry bufferUnion(Geometry geometry, Geometry geometry2) {
        return geometry.getFactory().createGeometryCollection(new Geometry[]{geometry, geometry2}).buffer(0.0);
    }

    private void computeInteracting() {
        int n = 0;
        while (n < this.g0.getNumGeometries()) {
            Geometry geometry = this.g0.getGeometryN(n);
            this.interacts0[n] = this.computeInteracting(geometry);
            ++n;
        }
        return;
    }

    private boolean computeInteracting(Geometry geometry) {
        int n = 0;
        boolean bl = false;
        while (n < this.g1.getNumGeometries()) {
            boolean bl2 = this.g1.getGeometryN(n).getEnvelopeInternal().intersects(geometry.getEnvelopeInternal());
            if (bl2) {
                this.interacts1[n] = true;
            }
            if (bl2) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private Geometry extractElements(Geometry geometry, boolean[] blArray, boolean bl) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            Geometry geometry2 = geometry.getGeometryN(n);
            if (blArray[n] == bl) {
                arrayList.add(geometry2);
            }
            ++n;
        }
        return this.geomFactory.buildGeometry(arrayList);
    }

    public static Geometry union(Geometry geometry, Geometry geometry2) {
        return new UnionInteracting(geometry, geometry2).union();
    }

    public Geometry union() {
        this.computeInteracting();
        Geometry geometry = this.extractElements(this.g0, this.interacts0, true);
        Geometry geometry2 = this.extractElements(this.g1, this.interacts1, true);
        if (geometry.isEmpty() || geometry2.isEmpty()) {
            System.out.println("found empty!");
        }
        return GeometryCombiner.combine(geometry.union(geometry2), this.extractElements(this.g0, this.interacts0, false), this.extractElements(this.g1, this.interacts1, false));
    }
}

