/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.MCPointInRing;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.EdgeIntersectionList;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.valid.ConnectedInteriorTester;
import com.vividsolutions.jts.operation.valid.ConsistentAreaTester;
import com.vividsolutions.jts.operation.valid.IndexedNestedRingTester;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.util.Assert;
import java.util.TreeSet;

public class IsValidOp {
    private boolean isSelfTouchingRingFormingHoleValid = false;
    private Geometry parentGeometry;
    private TopologyValidationError validErr;

    public IsValidOp(Geometry geometry) {
        this.parentGeometry = geometry;
    }

    private void checkClosedRing(LinearRing linearRing) {
        if (!linearRing.isClosed()) {
            Coordinate coordinate = null;
            if (linearRing.getNumPoints() >= 1) {
                coordinate = linearRing.getCoordinateN(0);
            }
            this.validErr = new TopologyValidationError(11, coordinate);
        }
    }

    private void checkClosedRings(Polygon polygon) {
        this.checkClosedRing((LinearRing)polygon.getExteriorRing());
        if (this.validErr != null) {
            return;
        }
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            this.checkClosedRing((LinearRing)polygon.getInteriorRingN(n));
            if (this.validErr != null) {
                return;
            }
            ++n;
        }
        return;
    }

    private void checkConnectedInteriors(GeometryGraph object) {
        if (!((ConnectedInteriorTester)(object = new ConnectedInteriorTester((GeometryGraph)object))).isInteriorsConnected()) {
            this.validErr = new TopologyValidationError(4, ((ConnectedInteriorTester)object).getCoordinate());
        }
    }

    private void checkConsistentArea(GeometryGraph object) {
        if (!((ConsistentAreaTester)(object = new ConsistentAreaTester((GeometryGraph)object))).isNodeConsistentArea()) {
            this.validErr = new TopologyValidationError(5, ((ConsistentAreaTester)object).getInvalidPoint());
            return;
        }
        if (((ConsistentAreaTester)object).hasDuplicateRings()) {
            this.validErr = new TopologyValidationError(8, ((ConsistentAreaTester)object).getInvalidPoint());
        }
    }

    private void checkHolesInShell(Polygon polygon, GeometryGraph geometryGraph) {
        LinearRing linearRing = (LinearRing)polygon.getExteriorRing();
        MCPointInRing mCPointInRing = new MCPointInRing(linearRing);
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            Coordinate coordinate = IsValidOp.findPtNotNode(((LinearRing)polygon.getInteriorRingN(n)).getCoordinates(), linearRing, geometryGraph);
            if (coordinate == null) {
                return;
            }
            if (mCPointInRing.isInside(coordinate) ^ true) {
                this.validErr = new TopologyValidationError(2, coordinate);
                return;
            }
            ++n;
        }
        return;
    }

    private void checkHolesNotNested(Polygon polygon, GeometryGraph object) {
        object = new IndexedNestedRingTester((GeometryGraph)object);
        int n = 0;
        while (true) {
            if (n >= polygon.getNumInteriorRing()) {
                if (!((IndexedNestedRingTester)object).isNonNested()) {
                    this.validErr = new TopologyValidationError(3, ((IndexedNestedRingTester)object).getNestedPoint());
                }
                return;
            }
            ((IndexedNestedRingTester)object).add((LinearRing)polygon.getInteriorRingN(n));
            ++n;
        }
    }

    private void checkInvalidCoordinates(Polygon polygon) {
        this.checkInvalidCoordinates(polygon.getExteriorRing().getCoordinates());
        if (this.validErr != null) {
            return;
        }
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            this.checkInvalidCoordinates(polygon.getInteriorRingN(n).getCoordinates());
            if (this.validErr != null) {
                return;
            }
            ++n;
        }
        return;
    }

    private void checkInvalidCoordinates(Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length) {
            if (!IsValidOp.isValid(coordinateArray[n])) {
                this.validErr = new TopologyValidationError(10, coordinateArray[n]);
                return;
            }
            ++n;
        }
        return;
    }

    private void checkNoSelfIntersectingRing(EdgeIntersectionList object) {
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>();
        object = ((EdgeIntersectionList)object).iterator();
        boolean bl = true;
        while (object.hasNext()) {
            EdgeIntersection edgeIntersection = (EdgeIntersection)object.next();
            if (bl) {
                bl = false;
                continue;
            }
            if (treeSet.contains(edgeIntersection.coord)) {
                this.validErr = new TopologyValidationError(6, edgeIntersection.coord);
                return;
            }
            treeSet.add(edgeIntersection.coord);
        }
        return;
    }

    private void checkNoSelfIntersectingRings(GeometryGraph object) {
        object = ((PlanarGraph)object).getEdgeIterator();
        do {
            if (!object.hasNext()) {
                return;
            }
            this.checkNoSelfIntersectingRing(((Edge)object.next()).getEdgeIntersectionList());
        } while (this.validErr == null);
    }

    private Coordinate checkShellInsideHole(LinearRing cloneable, LinearRing cloneable2, GeometryGraph geometryGraph) {
        Coordinate[] coordinateArray = cloneable.getCoordinates();
        Coordinate[] coordinateArray2 = cloneable2.getCoordinates();
        if ((cloneable2 = IsValidOp.findPtNotNode(coordinateArray, cloneable2, geometryGraph)) != null && !CGAlgorithms.isPointInRing((Coordinate)cloneable2, coordinateArray2)) {
            return cloneable2;
        }
        if ((cloneable = IsValidOp.findPtNotNode(coordinateArray2, cloneable, geometryGraph)) != null) {
            if (CGAlgorithms.isPointInRing((Coordinate)cloneable, coordinateArray)) {
                return cloneable;
            }
            return null;
        }
        Assert.shouldNeverReachHere("points in shell and hole appear to be equal");
        return null;
    }

    private void checkShellNotNested(LinearRing linearRing, Polygon polygon, GeometryGraph geometryGraph) {
        Coordinate[] coordinateArray = linearRing.getCoordinates();
        Cloneable cloneable = (LinearRing)polygon.getExteriorRing();
        Object object = cloneable.getCoordinates();
        if ((cloneable = IsValidOp.findPtNotNode(coordinateArray, cloneable, geometryGraph)) == null) {
            return;
        }
        if (!CGAlgorithms.isPointInRing((Coordinate)cloneable, object)) {
            return;
        }
        if (polygon.getNumInteriorRing() <= 0) {
            this.validErr = new TopologyValidationError(7, (Coordinate)cloneable);
            return;
        }
        object = null;
        int n = 0;
        while (true) {
            if (n >= polygon.getNumInteriorRing()) {
                this.validErr = new TopologyValidationError(7, (Coordinate)object);
                return;
            }
            object = this.checkShellInsideHole(linearRing, (LinearRing)polygon.getInteriorRingN(n), geometryGraph);
            if (object == null) {
                return;
            }
            ++n;
        }
    }

    private void checkShellsNotNested(MultiPolygon multiPolygon, GeometryGraph geometryGraph) {
        int n = 0;
        block0: while (n < multiPolygon.getNumGeometries()) {
            LinearRing linearRing = (LinearRing)((Polygon)multiPolygon.getGeometryN(n)).getExteriorRing();
            int n2 = 0;
            while (true) {
                if (n2 >= multiPolygon.getNumGeometries()) {
                    ++n;
                    continue block0;
                }
                if (n != n2) {
                    this.checkShellNotNested(linearRing, (Polygon)multiPolygon.getGeometryN(n2), geometryGraph);
                    if (this.validErr != null) {
                        return;
                    }
                }
                ++n2;
            }
            break;
        }
        return;
    }

    private void checkTooFewPoints(GeometryGraph geometryGraph) {
        if (geometryGraph.hasTooFewPoints()) {
            this.validErr = new TopologyValidationError(9, geometryGraph.getInvalidPoint());
        }
    }

    private void checkValid(Geometry geometry) {
        block11: {
            block5: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        this.validErr = null;
                                        if (geometry.isEmpty()) {
                                            return;
                                        }
                                        if (!(geometry instanceof Point)) break block4;
                                        this.checkValid((Point)geometry);
                                        break block5;
                                    }
                                    if (!(geometry instanceof MultiPoint)) break block6;
                                    this.checkValid((MultiPoint)geometry);
                                    break block5;
                                }
                                if (!(geometry instanceof LinearRing)) break block7;
                                this.checkValid((LinearRing)geometry);
                                break block5;
                            }
                            if (!(geometry instanceof LineString)) break block8;
                            this.checkValid((LineString)geometry);
                            break block5;
                        }
                        if (!(geometry instanceof Polygon)) break block9;
                        this.checkValid((Polygon)geometry);
                        break block5;
                    }
                    if (!(geometry instanceof MultiPolygon)) break block10;
                    this.checkValid((MultiPolygon)geometry);
                    break block5;
                }
                if (!(geometry instanceof GeometryCollection)) break block11;
                this.checkValid((GeometryCollection)geometry);
            }
            return;
        }
        throw new UnsupportedOperationException(geometry.getClass().getName());
    }

    private void checkValid(GeometryCollection geometryCollection) {
        int n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            this.checkValid(geometryCollection.getGeometryN(n));
            if (this.validErr != null) {
                return;
            }
            ++n;
        }
        return;
    }

    private void checkValid(LineString lineString) {
        this.checkInvalidCoordinates(lineString.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        this.checkTooFewPoints(new GeometryGraph(0, lineString));
    }

    private void checkValid(LinearRing object) {
        this.checkInvalidCoordinates(((LineString)object).getCoordinates());
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRing((LinearRing)object);
        if (this.validErr != null) {
            return;
        }
        object = new GeometryGraph(0, (Geometry)object);
        this.checkTooFewPoints((GeometryGraph)object);
        if (this.validErr != null) {
            return;
        }
        ((GeometryGraph)object).computeSelfNodes(new RobustLineIntersector(), true);
        this.checkNoSelfIntersectingRings((GeometryGraph)object);
    }

    private void checkValid(MultiPoint multiPoint) {
        this.checkInvalidCoordinates(multiPoint.getCoordinates());
    }

    private void checkValid(MultiPolygon multiPolygon) {
        int n = 0;
        int n2 = 0;
        while (true) {
            Object object;
            if (n2 >= multiPolygon.getNumGeometries()) {
                object = new GeometryGraph(0, multiPolygon);
                this.checkTooFewPoints((GeometryGraph)object);
                if (this.validErr != null) {
                    return;
                }
                this.checkConsistentArea((GeometryGraph)object);
                if (this.validErr != null) {
                    return;
                }
                if (!this.isSelfTouchingRingFormingHoleValid) {
                    this.checkNoSelfIntersectingRings((GeometryGraph)object);
                    if (this.validErr != null) {
                        return;
                    }
                }
                n2 = 0;
                while (true) {
                    if (n2 >= multiPolygon.getNumGeometries()) {
                        n2 = n;
                        while (true) {
                            if (n2 >= multiPolygon.getNumGeometries()) {
                                this.checkShellsNotNested(multiPolygon, (GeometryGraph)object);
                                if (this.validErr != null) {
                                    return;
                                }
                                this.checkConnectedInteriors((GeometryGraph)object);
                                return;
                            }
                            this.checkHolesNotNested((Polygon)multiPolygon.getGeometryN(n2), (GeometryGraph)object);
                            if (this.validErr != null) {
                                return;
                            }
                            ++n2;
                        }
                    }
                    this.checkHolesInShell((Polygon)multiPolygon.getGeometryN(n2), (GeometryGraph)object);
                    if (this.validErr != null) {
                        return;
                    }
                    ++n2;
                }
            }
            object = (Polygon)multiPolygon.getGeometryN(n2);
            this.checkInvalidCoordinates((Polygon)object);
            if (this.validErr != null) {
                return;
            }
            this.checkClosedRings((Polygon)object);
            if (this.validErr != null) {
                return;
            }
            ++n2;
        }
    }

    private void checkValid(Point point) {
        this.checkInvalidCoordinates(point.getCoordinates());
    }

    private void checkValid(Polygon polygon) {
        this.checkInvalidCoordinates(polygon);
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRings(polygon);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, polygon);
        this.checkTooFewPoints(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(geometryGraph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(geometryGraph);
            if (this.validErr != null) {
                return;
            }
        }
        this.checkHolesInShell(polygon, geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkHolesNotNested(polygon, geometryGraph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(geometryGraph);
    }

    public static Coordinate findPtNotNode(Coordinate[] coordinateArray, LinearRing cloneable, GeometryGraph object) {
        object = ((GeometryGraph)object).findEdge((LineString)cloneable).getEdgeIntersectionList();
        int n = 0;
        while (n < coordinateArray.length) {
            cloneable = coordinateArray[n];
            if (!((EdgeIntersectionList)object).isIntersection((Coordinate)cloneable)) {
                return cloneable;
            }
            ++n;
        }
        return null;
    }

    public static boolean isValid(Coordinate coordinate) {
        if (Double.isNaN(coordinate.x)) {
            return false;
        }
        if (Double.isInfinite(coordinate.x)) {
            return false;
        }
        if (Double.isNaN(coordinate.y)) {
            return false;
        }
        return !Double.isInfinite(coordinate.y);
    }

    public static boolean isValid(Geometry geometry) {
        return new IsValidOp(geometry).isValid();
    }

    public TopologyValidationError getValidationError() {
        this.checkValid(this.parentGeometry);
        return this.validErr;
    }

    public boolean isValid() {
        this.checkValid(this.parentGeometry);
        return this.validErr == null;
    }

    public void setSelfTouchingRingFormingHoleValid(boolean bl) {
        this.isSelfTouchingRingFormingHoleValid = bl;
    }
}

