/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class QuadtreeNestedRingTester {
    private GeometryGraph graph;
    private Coordinate nestedPt;
    private Quadtree quadtree;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();

    public QuadtreeNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    private void buildQuadtree() {
        this.quadtree = new Quadtree();
        int n = 0;
        while (n < this.rings.size()) {
            LinearRing linearRing = (LinearRing)this.rings.get(n);
            Envelope envelope = linearRing.getEnvelopeInternal();
            this.quadtree.insert(envelope, linearRing);
            ++n;
        }
        return;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
        this.totalEnv.expandToInclude(linearRing.getEnvelopeInternal());
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNonNested() {
        this.buildQuadtree();
        int n = 0;
        block0: while (n < this.rings.size()) {
            LinearRing linearRing = (LinearRing)this.rings.get(n);
            Coordinate[] coordinateArray = linearRing.getCoordinates();
            List list = this.quadtree.query(linearRing.getEnvelopeInternal());
            int n2 = 0;
            while (true) {
                if (n2 >= list.size()) {
                    ++n;
                    continue block0;
                }
                Cloneable cloneable = (LinearRing)list.get(n2);
                Coordinate[] coordinateArray2 = cloneable.getCoordinates();
                if (linearRing != cloneable && linearRing.getEnvelopeInternal().intersects(cloneable.getEnvelopeInternal())) {
                    boolean bl = (cloneable = IsValidOp.findPtNotNode(coordinateArray, cloneable, this.graph)) != null;
                    Assert.isTrue(bl, "Unable to find a ring point not a node of the search ring");
                    if (CGAlgorithms.isPointInRing((Coordinate)cloneable, coordinateArray2)) {
                        this.nestedPt = cloneable;
                        return false;
                    }
                }
                ++n2;
            }
            break;
        }
        return true;
    }
}

