/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.DirectedEdgeStar;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import java.util.Collection;
import java.util.HashSet;

public class Node
extends GraphComponent {
    protected DirectedEdgeStar deStar;
    protected Coordinate pt;

    public Node(Coordinate coordinate) {
        this(coordinate, new DirectedEdgeStar());
    }

    public Node(Coordinate coordinate, DirectedEdgeStar directedEdgeStar) {
        this.pt = coordinate;
        this.deStar = directedEdgeStar;
    }

    public static Collection getEdgesBetween(Node object, Node node) {
        object = new HashSet(DirectedEdge.toEdges(((Node)object).getOutEdges().getEdges()));
        object.retainAll(DirectedEdge.toEdges(node.getOutEdges().getEdges()));
        return object;
    }

    public void addOutEdge(DirectedEdge directedEdge) {
        this.deStar.add(directedEdge);
    }

    public Coordinate getCoordinate() {
        return this.pt;
    }

    public int getDegree() {
        return this.deStar.getDegree();
    }

    public int getIndex(Edge edge) {
        return this.deStar.getIndex(edge);
    }

    public DirectedEdgeStar getOutEdges() {
        return this.deStar;
    }

    @Override
    public boolean isRemoved() {
        return this.pt == null;
    }

    void remove() {
        this.pt = null;
    }

    public void remove(DirectedEdge directedEdge) {
        this.deStar.remove(directedEdge);
    }
}

