/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.NodeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class PlanarGraph {
    protected Set dirEdges;
    protected Set edges = new HashSet();
    protected NodeMap nodeMap;

    public PlanarGraph() {
        this.dirEdges = new HashSet();
        this.nodeMap = new NodeMap();
    }

    protected void add(DirectedEdge directedEdge) {
        this.dirEdges.add(directedEdge);
    }

    protected void add(Edge edge) {
        this.edges.add(edge);
        this.add(edge.getDirEdge(0));
        this.add(edge.getDirEdge(1));
    }

    protected void add(Node node) {
        this.nodeMap.add(node);
    }

    public boolean contains(DirectedEdge directedEdge) {
        return this.dirEdges.contains(directedEdge);
    }

    public boolean contains(Edge edge) {
        return this.edges.contains(edge);
    }

    public Iterator dirEdgeIterator() {
        return this.dirEdges.iterator();
    }

    public Iterator edgeIterator() {
        return this.edges.iterator();
    }

    public Node findNode(Coordinate coordinate) {
        return this.nodeMap.find(coordinate);
    }

    public List findNodesOfDegree(int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Iterator iterator2 = this.nodeIterator();
        while (iterator2.hasNext()) {
            Node node = (Node)iterator2.next();
            if (node.getDegree() != n) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public Collection getEdges() {
        return this.edges;
    }

    public Collection getNodes() {
        return this.nodeMap.values();
    }

    public Iterator nodeIterator() {
        return this.nodeMap.iterator();
    }

    public void remove(DirectedEdge directedEdge) {
        DirectedEdge directedEdge2 = directedEdge.getSym();
        if (directedEdge2 != null) {
            directedEdge2.setSym(null);
        }
        directedEdge.getFromNode().remove(directedEdge);
        directedEdge.remove();
        this.dirEdges.remove(directedEdge);
    }

    public void remove(Edge edge) {
        this.remove(edge.getDirEdge(0));
        this.remove(edge.getDirEdge(1));
        this.edges.remove(edge);
        edge.remove();
    }

    public void remove(Node node) {
        Iterator iterator2 = node.getOutEdges().getEdges().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                this.nodeMap.remove(node.getCoordinate());
                node.remove();
                return;
            }
            GraphComponent graphComponent = (DirectedEdge)iterator2.next();
            DirectedEdge directedEdge = graphComponent.getSym();
            if (directedEdge != null) {
                this.remove(directedEdge);
            }
            this.dirEdges.remove(graphComponent);
            if ((graphComponent = graphComponent.getEdge()) == null) continue;
            this.edges.remove(graphComponent);
        }
    }
}

