/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

public class CommonBits {
    private long commonBits = 0L;
    private int commonMantissaBitsCount = 53;
    private long commonSignExp;
    private boolean isFirst = true;

    public static int getBit(long l, int n) {
        n = (l & 1L << n) != 0L ? 1 : 0;
        return n;
    }

    public static int numCommonMostSigMantissaBits(long l, long l2) {
        int n = 0;
        int n2 = 52;
        while (n2 >= 0) {
            if (CommonBits.getBit(l, n2) != CommonBits.getBit(l2, n2)) {
                return n;
            }
            ++n;
            --n2;
        }
        return 52;
    }

    public static long signExpBits(long l) {
        return l >> 52;
    }

    public static long zeroLowerBits(long l, int n) {
        return l & (1L << n) - 1L;
    }

    public void add(double d) {
        int n;
        long l = Double.doubleToLongBits(d);
        if (this.isFirst) {
            this.commonBits = l;
            this.commonSignExp = CommonBits.signExpBits(l);
            this.isFirst = false;
            return;
        }
        if (CommonBits.signExpBits(l) != this.commonSignExp) {
            this.commonBits = 0L;
            return;
        }
        this.commonMantissaBitsCount = n = CommonBits.numCommonMostSigMantissaBits(this.commonBits, l);
        this.commonBits = CommonBits.zeroLowerBits(this.commonBits, 64 - (n + 12));
    }

    public double getCommon() {
        return Double.longBitsToDouble(this.commonBits);
    }

    public String toString(long l) {
        double d = Double.longBitsToDouble(l);
        String string2 = Long.toBinaryString(l);
        CharSequence charSequence = new StringBuilder("0000000000000000000000000000000000000000000000000000000000000000");
        ((StringBuilder)charSequence).append(string2);
        charSequence = ((StringBuilder)charSequence).toString();
        string2 = ((String)charSequence).substring(((String)charSequence).length() - 64);
        charSequence = new StringBuilder(String.valueOf(string2.substring(0, 1)));
        ((StringBuilder)charSequence).append("  ");
        ((StringBuilder)charSequence).append(string2.substring(1, 12));
        ((StringBuilder)charSequence).append("(exp) ");
        ((StringBuilder)charSequence).append(string2.substring(12));
        ((StringBuilder)charSequence).append(" [ ");
        ((StringBuilder)charSequence).append(d);
        ((StringBuilder)charSequence).append(" ]");
        return ((StringBuilder)charSequence).toString();
    }
}

