/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.precision.CommonBitsRemover;

public class CommonBitsOp {
    private CommonBitsRemover cbr;
    private boolean returnToOriginalPrecision = true;

    public CommonBitsOp() {
        this(true);
    }

    public CommonBitsOp(boolean bl) {
        this.returnToOriginalPrecision = bl;
    }

    private Geometry computeResultPrecision(Geometry geometry) {
        if (this.returnToOriginalPrecision) {
            this.cbr.addCommonBits(geometry);
        }
        return geometry;
    }

    private Geometry removeCommonBits(Geometry geometry) {
        CommonBitsRemover commonBitsRemover;
        this.cbr = commonBitsRemover = new CommonBitsRemover();
        commonBitsRemover.add(geometry);
        return this.cbr.removeCommonBits((Geometry)geometry.clone());
    }

    private Geometry[] removeCommonBits(Geometry geometry, Geometry geometry2) {
        CommonBitsRemover commonBitsRemover;
        this.cbr = commonBitsRemover = new CommonBitsRemover();
        commonBitsRemover.add(geometry);
        this.cbr.add(geometry2);
        return new Geometry[]{this.cbr.removeCommonBits((Geometry)geometry.clone()), this.cbr.removeCommonBits((Geometry)geometry2.clone())};
    }

    public Geometry buffer(Geometry geometry, double d) {
        return this.computeResultPrecision(this.removeCommonBits(geometry).buffer(d));
    }

    public Geometry difference(Geometry geometryArray, Geometry geometry) {
        geometryArray = this.removeCommonBits((Geometry)geometryArray, geometry);
        return this.computeResultPrecision(geometryArray[0].difference(geometryArray[1]));
    }

    public Geometry intersection(Geometry geometryArray, Geometry geometry) {
        geometryArray = this.removeCommonBits((Geometry)geometryArray, geometry);
        return this.computeResultPrecision(geometryArray[0].intersection(geometryArray[1]));
    }

    public Geometry symDifference(Geometry geometryArray, Geometry geometry) {
        geometryArray = this.removeCommonBits((Geometry)geometryArray, geometry);
        return this.computeResultPrecision(geometryArray[0].symDifference(geometryArray[1]));
    }

    public Geometry union(Geometry geometryArray, Geometry geometry) {
        geometryArray = this.removeCommonBits((Geometry)geometryArray, geometry);
        return this.computeResultPrecision(geometryArray[0].union(geometryArray[1]));
    }
}

