/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.precision.CommonBits;

public class CommonBitsRemover {
    private CommonCoordinateFilter ccFilter = new CommonCoordinateFilter();
    private Coordinate commonCoord;

    public void add(Geometry geometry) {
        geometry.apply(this.ccFilter);
        this.commonCoord = this.ccFilter.getCommonCoordinate();
    }

    public void addCommonBits(Geometry geometry) {
        geometry.apply(new Translater(this.commonCoord));
        geometry.geometryChanged();
    }

    public Coordinate getCommonCoordinate() {
        return this.commonCoord;
    }

    public Geometry removeCommonBits(Geometry geometry) {
        if (this.commonCoord.x == 0.0 && this.commonCoord.y == 0.0) {
            return geometry;
        }
        Coordinate coordinate = new Coordinate(this.commonCoord);
        coordinate.x = -coordinate.x;
        coordinate.y = -coordinate.y;
        geometry.apply(new Translater(coordinate));
        geometry.geometryChanged();
        return geometry;
    }

    class CommonCoordinateFilter
    implements CoordinateFilter {
        private CommonBits commonBitsX = new CommonBits();
        private CommonBits commonBitsY = new CommonBits();

        CommonCoordinateFilter() {
        }

        @Override
        public void filter(Coordinate coordinate) {
            this.commonBitsX.add(coordinate.x);
            this.commonBitsY.add(coordinate.y);
        }

        public Coordinate getCommonCoordinate() {
            return new Coordinate(this.commonBitsX.getCommon(), this.commonBitsY.getCommon());
        }
    }

    class Translater
    implements CoordinateSequenceFilter {
        Coordinate trans = null;

        public Translater(Coordinate coordinate) {
            this.trans = coordinate;
        }

        @Override
        public void filter(CoordinateSequence coordinateSequence, int n) {
            double d = coordinateSequence.getOrdinate(n, 0);
            double d2 = this.trans.x;
            double d3 = coordinateSequence.getOrdinate(n, 1);
            double d4 = this.trans.y;
            coordinateSequence.setOrdinate(n, 0, d + d2);
            coordinateSequence.setOrdinate(n, 1, d3 + d4);
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isGeometryChanged() {
            return true;
        }
    }
}

