/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryEditor;
import com.vividsolutions.jts.precision.PrecisionReducerCoordinateOperation;

public class GeometryPrecisionReducer {
    private boolean changePrecisionModel = false;
    private boolean isPointwise = false;
    private boolean removeCollapsed = true;
    private PrecisionModel targetPM;

    public GeometryPrecisionReducer(PrecisionModel precisionModel) {
        this.targetPM = precisionModel;
    }

    private Geometry changePM(Geometry geometry, PrecisionModel precisionModel) {
        return this.createEditor(geometry.getFactory(), precisionModel).edit(geometry, new GeometryEditor.NoOpGeometryOperation());
    }

    private GeometryEditor createEditor(GeometryFactory geometryFactory, PrecisionModel precisionModel) {
        if (geometryFactory.getPrecisionModel() == precisionModel) {
            return new GeometryEditor();
        }
        return new GeometryEditor(this.createFactory(geometryFactory, precisionModel));
    }

    private GeometryFactory createFactory(GeometryFactory geometryFactory, PrecisionModel precisionModel) {
        return new GeometryFactory(precisionModel, geometryFactory.getSRID(), geometryFactory.getCoordinateSequenceFactory());
    }

    private Geometry fixPolygonalTopology(Geometry geometry) {
        Geometry geometry2;
        Geometry geometry3 = !this.changePrecisionModel ? this.changePM(geometry, this.targetPM) : geometry;
        geometry3 = geometry2 = geometry3.buffer(0.0);
        if (!this.changePrecisionModel) {
            geometry3 = geometry.getFactory().createGeometry(geometry2);
        }
        return geometry3;
    }

    public static Geometry reduce(Geometry geometry, PrecisionModel precisionModel) {
        return new GeometryPrecisionReducer(precisionModel).reduce(geometry);
    }

    private Geometry reducePointwise(Geometry geometry) {
        GeometryEditor geometryEditor = this.changePrecisionModel ? new GeometryEditor(this.createFactory(geometry.getFactory(), this.targetPM)) : new GeometryEditor();
        boolean bl = this.removeCollapsed;
        if (geometry.getDimension() >= 2) {
            bl = true;
        }
        return geometryEditor.edit(geometry, new PrecisionReducerCoordinateOperation(this.targetPM, bl));
    }

    public static Geometry reducePointwise(Geometry geometry, PrecisionModel object) {
        object = new GeometryPrecisionReducer((PrecisionModel)object);
        ((GeometryPrecisionReducer)object).setPointwise(true);
        return ((GeometryPrecisionReducer)object).reduce(geometry);
    }

    public Geometry reduce(Geometry geometry) {
        geometry = this.reducePointwise(geometry);
        if (this.isPointwise) {
            return geometry;
        }
        if (!(geometry instanceof Polygonal)) {
            return geometry;
        }
        if (geometry.isValid()) {
            return geometry;
        }
        return this.fixPolygonalTopology(geometry);
    }

    public void setChangePrecisionModel(boolean bl) {
        this.changePrecisionModel = bl;
    }

    public void setPointwise(boolean bl) {
        this.isPointwise = bl;
    }

    public void setRemoveCollapsedComponents(boolean bl) {
        this.removeCollapsed = bl;
    }
}

