/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryEditor;

public class SimpleGeometryPrecisionReducer {
    private boolean changePrecisionModel = false;
    private PrecisionModel newPrecisionModel;
    private boolean removeCollapsed = true;

    public SimpleGeometryPrecisionReducer(PrecisionModel precisionModel) {
        this.newPrecisionModel = precisionModel;
    }

    public static Geometry reduce(Geometry geometry, PrecisionModel precisionModel) {
        return new SimpleGeometryPrecisionReducer(precisionModel).reduce(geometry);
    }

    public Geometry reduce(Geometry geometry) {
        GeometryEditor geometryEditor = this.changePrecisionModel ? new GeometryEditor(new GeometryFactory(this.newPrecisionModel, geometry.getFactory().getSRID())) : new GeometryEditor();
        return geometryEditor.edit(geometry, new PrecisionReducerCoordinateOperation());
    }

    public void setChangePrecisionModel(boolean bl) {
        this.changePrecisionModel = bl;
    }

    public void setRemoveCollapsedComponents(boolean bl) {
        this.removeCollapsed = bl;
    }

    private class PrecisionReducerCoordinateOperation
    extends GeometryEditor.CoordinateOperation {
        private PrecisionReducerCoordinateOperation() {
        }

        @Override
        public Coordinate[] edit(Coordinate[] object, Geometry geometry) {
            int n = ((Coordinate[])object).length;
            Object var4_4 = null;
            if (n == 0) {
                return null;
            }
            Coordinate[] coordinateArray = new Coordinate[((Coordinate[])object).length];
            int n2 = 0;
            n = 0;
            while (true) {
                Coordinate[] coordinateArray2;
                if (n >= ((Coordinate[])object).length) {
                    coordinateArray2 = new CoordinateList(coordinateArray, false).toCoordinateArray();
                    n = n2;
                    if (geometry instanceof LineString) {
                        n = 2;
                    }
                    if (geometry instanceof LinearRing) {
                        n = 4;
                    }
                    object = SimpleGeometryPrecisionReducer.this.removeCollapsed ? var4_4 : coordinateArray;
                    if (coordinateArray2.length < n) {
                        return object;
                    }
                    return coordinateArray2;
                }
                coordinateArray2 = new Coordinate(object[n]);
                SimpleGeometryPrecisionReducer.this.newPrecisionModel.makePrecise((Coordinate)coordinateArray2);
                coordinateArray[n] = coordinateArray2;
                ++n;
            }
        }
    }
}

