/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.shape.fractal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.math.Vector2D;
import com.vividsolutions.jts.shape.GeometricShapeBuilder;

public class KochSnowflakeBuilder
extends GeometricShapeBuilder {
    private static final double HEIGHT_FACTOR;
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double THIRD_HEIGHT;
    private static final double TWO_THIRDS = 0.6666666666666666;
    private CoordinateList coordList = new CoordinateList();

    static {
        double d;
        HEIGHT_FACTOR = d = Math.sin(1.0471975511965976);
        THIRD_HEIGHT = d / 3.0;
    }

    public KochSnowflakeBuilder(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    private void addSegment(Coordinate coordinate, Coordinate coordinate2) {
        this.coordList.add(coordinate2);
    }

    private Coordinate[] getBoundary(int n, Coordinate coordinate, double d) {
        double d2;
        double d3 = d2 = coordinate.y;
        if (n > 0) {
            d3 = d2 + THIRD_HEIGHT * d;
        }
        Coordinate coordinate2 = new Coordinate(coordinate.x, d3);
        Coordinate coordinate3 = new Coordinate(coordinate.x + d / 2.0, HEIGHT_FACTOR * d + d3);
        coordinate = new Coordinate(coordinate.x + d, d3);
        this.addSide(n, coordinate2, coordinate3);
        this.addSide(n, coordinate3, coordinate);
        this.addSide(n, coordinate, coordinate2);
        this.coordList.closeRing();
        return this.coordList.toCoordinateArray();
    }

    public static int recursionLevelForSize(int n) {
        return (int)(Math.log(n / 3) / Math.log(4.0));
    }

    public void addSide(int n, Coordinate coordinate, Coordinate coordinate2) {
        if (n == 0) {
            this.addSegment(coordinate, coordinate2);
        } else {
            Object object = Vector2D.create(coordinate, coordinate2);
            Coordinate coordinate3 = ((Vector2D)object).multiply(0.5).translate(coordinate);
            coordinate3 = ((Vector2D)object).multiply(THIRD_HEIGHT).rotateByQuarterCircle(1).translate(coordinate3);
            Coordinate coordinate4 = ((Vector2D)object).multiply(0.3333333333333333).translate(coordinate);
            object = ((Vector2D)object).multiply(0.6666666666666666).translate(coordinate);
            this.addSide(--n, coordinate, coordinate4);
            this.addSide(n, coordinate4, coordinate3);
            this.addSide(n, coordinate3, (Coordinate)object);
            this.addSide(n, (Coordinate)object, coordinate2);
        }
    }

    @Override
    public Geometry getGeometry() {
        int n = KochSnowflakeBuilder.recursionLevelForSize(this.numPts);
        Coordinate[] coordinateArray = this.getSquareBaseLine();
        coordinateArray = this.getBoundary(n, coordinateArray.getCoordinate(0), coordinateArray.getLength());
        return this.geomFactory.createPolygon(this.geomFactory.createLinearRing(coordinateArray), null);
    }
}

