/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.simplify.TaggedLineSegment;
import java.util.ArrayList;
import java.util.List;

class TaggedLineString {
    private int minimumSize;
    private LineString parentLine;
    private List resultSegs = new ArrayList();
    private TaggedLineSegment[] segs;

    public TaggedLineString(LineString lineString) {
        this(lineString, 2);
    }

    public TaggedLineString(LineString lineString, int n) {
        this.parentLine = lineString;
        this.minimumSize = n;
        this.init();
    }

    private static Coordinate[] extractCoordinates(List list) {
        int n = list.size() + 1;
        Coordinate[] coordinateArray = new Coordinate[n];
        LineSegment lineSegment = null;
        int n2 = 0;
        while (true) {
            if (n2 >= list.size()) {
                coordinateArray[n - 1] = lineSegment.p1;
                return coordinateArray;
            }
            lineSegment = (LineSegment)list.get(n2);
            coordinateArray[n2] = lineSegment.p0;
            ++n2;
        }
    }

    private void init() {
        Coordinate[] coordinateArray = this.parentLine.getCoordinates();
        this.segs = new TaggedLineSegment[coordinateArray.length - 1];
        int n = 0;
        while (n < coordinateArray.length - 1) {
            Comparable comparable = coordinateArray[n];
            int n2 = n + 1;
            comparable = new TaggedLineSegment((Coordinate)comparable, coordinateArray[n2], this.parentLine, n);
            this.segs[n] = comparable;
            n = n2;
        }
        return;
    }

    public void addToResult(LineSegment lineSegment) {
        this.resultSegs.add(lineSegment);
    }

    public LineString asLineString() {
        return this.parentLine.getFactory().createLineString(TaggedLineString.extractCoordinates(this.resultSegs));
    }

    public LinearRing asLinearRing() {
        return this.parentLine.getFactory().createLinearRing(TaggedLineString.extractCoordinates(this.resultSegs));
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public LineString getParent() {
        return this.parentLine;
    }

    public Coordinate[] getParentCoordinates() {
        return this.parentLine.getCoordinates();
    }

    public Coordinate[] getResultCoordinates() {
        return TaggedLineString.extractCoordinates(this.resultSegs);
    }

    public int getResultSize() {
        int n = this.resultSegs.size();
        n = n == 0 ? 0 : ++n;
        return n;
    }

    public TaggedLineSegment getSegment(int n) {
        return this.segs[n];
    }

    public TaggedLineSegment[] getSegments() {
        return this.segs;
    }
}

