/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.simplify.LineSegmentIndex;
import com.vividsolutions.jts.simplify.TaggedLineSegment;
import com.vividsolutions.jts.simplify.TaggedLineString;
import java.util.Iterator;

public class TaggedLineStringSimplifier {
    private double distanceTolerance = 0.0;
    private LineSegmentIndex inputIndex;
    private LineIntersector li = new RobustLineIntersector();
    private TaggedLineString line;
    private Coordinate[] linePts;
    private LineSegmentIndex outputIndex;

    public TaggedLineStringSimplifier(LineSegmentIndex lineSegmentIndex, LineSegmentIndex lineSegmentIndex2) {
        this.inputIndex = new LineSegmentIndex();
        this.outputIndex = new LineSegmentIndex();
        this.inputIndex = lineSegmentIndex;
        this.outputIndex = lineSegmentIndex2;
    }

    private int findFurthestPoint(Coordinate[] coordinateArray, int n, int n2, double[] dArray) {
        LineSegment lineSegment = new LineSegment();
        lineSegment.p0 = coordinateArray[n];
        lineSegment.p1 = coordinateArray[n2];
        int n3 = n + 1;
        double d = -1.0;
        int n4 = n;
        n = n3;
        while (true) {
            if (n >= n2) {
                dArray[0] = d;
                return n4;
            }
            double d2 = lineSegment.distance(coordinateArray[n]);
            double d3 = d;
            if (d2 > d) {
                n4 = n;
                d3 = d2;
            }
            ++n;
            d = d3;
        }
    }

    private LineSegment flatten(int n, int n2) {
        Object object = this.linePts;
        object = new LineSegment(object[n], object[n2]);
        this.remove(this.line, n, n2);
        this.outputIndex.add((LineSegment)object);
        return object;
    }

    private boolean hasBadInputIntersection(TaggedLineString taggedLineString, int[] nArray, LineSegment lineSegment) {
        TaggedLineSegment taggedLineSegment;
        Iterator iterator2 = this.inputIndex.query(lineSegment).iterator();
        do {
            if (iterator2.hasNext()) continue;
            return false;
        } while (!this.hasInteriorIntersection(taggedLineSegment = (TaggedLineSegment)iterator2.next(), lineSegment) || TaggedLineStringSimplifier.isInLineSection(taggedLineString, nArray, taggedLineSegment));
        return true;
    }

    private boolean hasBadIntersection(TaggedLineString taggedLineString, int[] nArray, LineSegment lineSegment) {
        if (this.hasBadOutputIntersection(lineSegment)) {
            return true;
        }
        return this.hasBadInputIntersection(taggedLineString, nArray, lineSegment);
    }

    private boolean hasBadOutputIntersection(LineSegment lineSegment) {
        Iterator iterator2 = this.outputIndex.query(lineSegment).iterator();
        do {
            if (iterator2.hasNext()) continue;
            return false;
        } while (!this.hasInteriorIntersection((LineSegment)iterator2.next(), lineSegment));
        return true;
    }

    private boolean hasInteriorIntersection(LineSegment lineSegment, LineSegment lineSegment2) {
        this.li.computeIntersection(lineSegment.p0, lineSegment.p1, lineSegment2.p0, lineSegment2.p1);
        return this.li.isInteriorIntersection();
    }

    private static boolean isInLineSection(TaggedLineString taggedLineString, int[] nArray, TaggedLineSegment taggedLineSegment) {
        if (taggedLineSegment.getParent() != taggedLineString.getParent()) {
            return false;
        }
        int n = taggedLineSegment.getIndex();
        return n >= nArray[0] && n < nArray[1];
    }

    private void remove(TaggedLineString taggedLineString, int n, int n2) {
        while (n < n2) {
            TaggedLineSegment taggedLineSegment = taggedLineString.getSegment(n);
            this.inputIndex.remove(taggedLineSegment);
            ++n;
        }
        return;
    }

    private void simplifySection(int n, int n2, int n3) {
        int n4 = n3 + 1;
        if (n + 1 == n2) {
            TaggedLineSegment taggedLineSegment = this.line.getSegment(n);
            this.line.addToResult(taggedLineSegment);
            return;
        }
        n3 = this.line.getResultSize();
        int n5 = this.line.getMinimumSize();
        int n6 = 0;
        n3 = n3 < n5 && n4 + 1 < this.line.getMinimumSize() ? 0 : 1;
        Object object = new double[1];
        n5 = this.findFurthestPoint(this.linePts, n, n2, (double[])object);
        if (object[0] > this.distanceTolerance) {
            n3 = 0;
        }
        object = new LineSegment();
        object.p0 = this.linePts[n];
        object.p1 = this.linePts[n2];
        if (this.hasBadIntersection(this.line, new int[]{n, n2}, (LineSegment)object)) {
            n3 = n6;
        }
        if (n3 != 0) {
            object = this.flatten(n, n2);
            this.line.addToResult((LineSegment)object);
            return;
        }
        this.simplifySection(n, n5, n4);
        this.simplifySection(n5, n2, n4);
    }

    public void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    void simplify(TaggedLineString coordinateArray) {
        this.line = coordinateArray;
        coordinateArray = coordinateArray.getParentCoordinates();
        this.linePts = coordinateArray;
        this.simplifySection(0, coordinateArray.length - 1, 0);
    }
}

