/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import com.vividsolutions.jts.simplify.TaggedLineString;
import com.vividsolutions.jts.simplify.TaggedLinesSimplifier;
import java.util.HashMap;
import java.util.Map;

public class TopologyPreservingSimplifier {
    private Geometry inputGeom;
    private TaggedLinesSimplifier lineSimplifier = new TaggedLinesSimplifier();
    private Map linestringMap;

    public TopologyPreservingSimplifier(Geometry geometry) {
        this.inputGeom = geometry;
    }

    public static Geometry simplify(Geometry object, double d) {
        object = new TopologyPreservingSimplifier((Geometry)object);
        ((TopologyPreservingSimplifier)object).setDistanceTolerance(d);
        return ((TopologyPreservingSimplifier)object).getResultGeometry();
    }

    public Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return (Geometry)this.inputGeom.clone();
        }
        this.linestringMap = new HashMap();
        this.inputGeom.apply(new LineStringMapBuilderFilter());
        this.lineSimplifier.simplify(this.linestringMap.values());
        return new LineStringTransformer().transform(this.inputGeom);
    }

    public void setDistanceTolerance(double d) {
        if (!(d < 0.0)) {
            this.lineSimplifier.setDistanceTolerance(d);
            return;
        }
        throw new IllegalArgumentException("Tolerance must be non-negative");
    }

    class LineStringMapBuilderFilter
    implements GeometryComponentFilter {
        LineStringMapBuilderFilter() {
        }

        @Override
        public void filter(Geometry object) {
            if (object instanceof LineString) {
                LineString lineString = (LineString)object;
                if (lineString.isEmpty()) {
                    return;
                }
                int n = lineString.isClosed() ? 4 : 2;
                object = new TaggedLineString(lineString, n);
                TopologyPreservingSimplifier.this.linestringMap.put(lineString, object);
            }
        }
    }

    class LineStringTransformer
    extends GeometryTransformer {
        LineStringTransformer() {
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateSequence, Geometry geometry) {
            if (coordinateSequence.size() == 0) {
                return null;
            }
            if (geometry instanceof LineString) {
                return this.createCoordinateSequence(((TaggedLineString)TopologyPreservingSimplifier.this.linestringMap.get(geometry)).getResultCoordinates());
            }
            return super.transformCoordinates(coordinateSequence, geometry);
        }
    }
}

