/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.ConstraintVertex;
import com.vividsolutions.jts.triangulate.DelaunayTriangulationBuilder;
import com.vividsolutions.jts.triangulate.Segment;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConformingDelaunayTriangulationBuilder {
    private Geometry constraintLines;
    private Map constraintVertexMap = new TreeMap();
    private Collection siteCoords;
    private QuadEdgeSubdivision subdiv = null;
    private double tolerance = 0.0;

    private void create() {
        if (this.subdiv != null) {
            return;
        }
        Envelope envelope = DelaunayTriangulationBuilder.envelope(this.siteCoords);
        List list = new ArrayList();
        Object object = this.constraintLines;
        if (object != null) {
            envelope.expandToInclude(((Geometry)object).getEnvelopeInternal());
            this.createVertices(this.constraintLines);
            list = ConformingDelaunayTriangulationBuilder.createConstraintSegments(this.constraintLines);
        }
        object = new ConformingDelaunayTriangulator(this.createSiteVertices(this.siteCoords), this.tolerance);
        ((ConformingDelaunayTriangulator)object).setConstraints(list, new ArrayList(this.constraintVertexMap.values()));
        ((ConformingDelaunayTriangulator)object).formInitialDelaunay();
        ((ConformingDelaunayTriangulator)object).enforceConstraints();
        this.subdiv = ((ConformingDelaunayTriangulator)object).getSubdivision();
    }

    private static List createConstraintSegments(Geometry cloneable) {
        Object object = LinearComponentExtracter.getLines(cloneable);
        cloneable = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            ConformingDelaunayTriangulationBuilder.createConstraintSegments((LineString)object.next(), (List)((Object)cloneable));
        }
        return cloneable;
    }

    private static void createConstraintSegments(LineString coordinateArray, List list) {
        coordinateArray = coordinateArray.getCoordinates();
        int n = 1;
        while (n < coordinateArray.length) {
            list.add(new Segment(coordinateArray[n - 1], coordinateArray[n]));
            ++n;
        }
        return;
    }

    private List createSiteVertices(Collection object) {
        ArrayList<ConstraintVertex> arrayList = new ArrayList<ConstraintVertex>();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (Coordinate)iterator2.next();
            if (this.constraintVertexMap.containsKey(object)) continue;
            arrayList.add(new ConstraintVertex((Coordinate)object));
        }
        return arrayList;
    }

    private void createVertices(Geometry object) {
        Coordinate[] coordinateArray = ((Geometry)object).getCoordinates();
        int n = 0;
        while (n < coordinateArray.length) {
            object = new ConstraintVertex(coordinateArray[n]);
            this.constraintVertexMap.put(coordinateArray[n], object);
            ++n;
        }
        return;
    }

    public Geometry getEdges(GeometryFactory geometryFactory) {
        this.create();
        return this.subdiv.getEdges(geometryFactory);
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public Geometry getTriangles(GeometryFactory geometryFactory) {
        this.create();
        return this.subdiv.getTriangles(geometryFactory);
    }

    public void setConstraints(Geometry geometry) {
        this.constraintLines = geometry;
    }

    public void setSites(Geometry geometry) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geometry);
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }
}

