/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.index.kdtree.KdNode;
import com.vividsolutions.jts.index.kdtree.KdTree;
import com.vividsolutions.jts.triangulate.ConstraintEnforcementException;
import com.vividsolutions.jts.triangulate.ConstraintSplitPointFinder;
import com.vividsolutions.jts.triangulate.ConstraintVertex;
import com.vividsolutions.jts.triangulate.ConstraintVertexFactory;
import com.vividsolutions.jts.triangulate.IncrementalDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.NonEncroachingSplitPointFinder;
import com.vividsolutions.jts.triangulate.Segment;
import com.vividsolutions.jts.triangulate.quadedge.LastFoundQuadEdgeLocator;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import com.vividsolutions.jts.util.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ConformingDelaunayTriangulator {
    private static final int MAX_SPLIT_ITER = 99;
    private Envelope computeAreaEnv;
    private Geometry convexHull;
    private IncrementalDelaunayTriangulator incDel;
    private List initialVertices;
    private KdTree kdt = null;
    private List segVertices;
    private List segments = new ArrayList();
    private ConstraintSplitPointFinder splitFinder = new NonEncroachingSplitPointFinder();
    private Coordinate splitPt = null;
    private QuadEdgeSubdivision subdiv = null;
    private double tolerance;
    private ConstraintVertexFactory vertexFactory = null;

    public ConformingDelaunayTriangulator(Collection collection, double d) {
        this.initialVertices = new ArrayList(collection);
        this.tolerance = d;
        this.kdt = new KdTree(d);
    }

    private void addConstraintVertices() {
        this.computeConvexHull();
        this.insertSites(this.segVertices);
    }

    private void computeBoundingBox() {
        Envelope envelope = ConformingDelaunayTriangulator.computeVertexEnvelope(this.initialVertices);
        Envelope envelope2 = ConformingDelaunayTriangulator.computeVertexEnvelope(this.segVertices);
        envelope = new Envelope(envelope);
        envelope.expandToInclude(envelope2);
        double d = Math.max(envelope.getWidth() * 0.2, envelope.getHeight() * 0.2);
        this.computeAreaEnv = envelope2 = new Envelope(envelope);
        envelope2.expandBy(d);
    }

    private void computeConvexHull() {
        GeometryFactory geometryFactory = new GeometryFactory();
        this.convexHull = new ConvexHull(this.getPointArray(), geometryFactory).getConvexHull();
    }

    private static Envelope computeVertexEnvelope(Collection object) {
        Envelope envelope = new Envelope();
        object = object.iterator();
        while (object.hasNext()) {
            envelope.expandToInclude(((Vertex)object.next()).getCoordinate());
        }
        return envelope;
    }

    private ConstraintVertex createVertex(Coordinate object) {
        ConstraintVertexFactory constraintVertexFactory = this.vertexFactory;
        object = constraintVertexFactory != null ? constraintVertexFactory.createVertex((Coordinate)object, null) : new ConstraintVertex((Coordinate)object);
        return object;
    }

    private ConstraintVertex createVertex(Coordinate object, Segment segment) {
        ConstraintVertexFactory constraintVertexFactory = this.vertexFactory;
        object = constraintVertexFactory != null ? constraintVertexFactory.createVertex((Coordinate)object, segment) : new ConstraintVertex((Coordinate)object);
        ((ConstraintVertex)object).setOnConstraint(true);
        return object;
    }

    private int enforceGabriel(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Segment> arrayList2 = new ArrayList<Segment>();
        Iterator iterator2 = collection.iterator();
        int n = 0;
        while (true) {
            if (!iterator2.hasNext()) {
                collection.removeAll(arrayList2);
                collection.addAll(arrayList);
                return n;
            }
            Segment segment = (Segment)iterator2.next();
            Object object = this.findNonGabrielPoint(segment);
            if (object == null) continue;
            object = this.splitFinder.findSplitPoint(segment, (Coordinate)object);
            this.splitPt = object;
            Object object2 = this.insertSite((ConstraintVertex)(object = this.createVertex((Coordinate)object, segment)));
            if (!((Vertex)object2).getCoordinate().equals2D(this.splitPt)) {
                StringBuilder stringBuilder = new StringBuilder("Split pt snapped to: ");
                stringBuilder.append(object2);
                Debug.println(stringBuilder.toString());
            }
            object2 = new Segment(segment.getStartX(), segment.getStartY(), segment.getStartZ(), ((Vertex)object).getX(), ((Vertex)object).getY(), ((Vertex)object).getZ(), segment.getData());
            object = new Segment(((Vertex)object).getX(), ((Vertex)object).getY(), ((Vertex)object).getZ(), segment.getEndX(), segment.getEndY(), segment.getEndZ(), segment.getData());
            arrayList.add(object2);
            arrayList.add(object);
            arrayList2.add(segment);
            ++n;
        }
    }

    private Coordinate findNonGabrielPoint(Segment object) {
        Coordinate coordinate = ((Segment)object).getStart();
        Coordinate coordinate2 = ((Segment)object).getEnd();
        Coordinate coordinate3 = new Coordinate((coordinate.x + coordinate2.x) / 2.0, (coordinate.y + coordinate2.y) / 2.0);
        double d = coordinate.distance(coordinate3);
        object = new Envelope(coordinate3);
        ((Envelope)object).expandBy(d);
        Iterator iterator2 = this.kdt.query((Envelope)object).iterator();
        object = null;
        double d2 = Double.MAX_VALUE;
        while (iterator2.hasNext()) {
            double d3;
            Coordinate coordinate4 = ((KdNode)iterator2.next()).getCoordinate();
            if (coordinate4.equals2D(coordinate) || coordinate4.equals2D(coordinate2) || !((d3 = coordinate3.distance(coordinate4)) < d) || object != null && !(d3 < d2)) continue;
            object = coordinate4;
            d2 = d3;
        }
        return object;
    }

    private Coordinate[] getPointArray() {
        Coordinate[] coordinateArray = new Coordinate[this.initialVertices.size() + this.segVertices.size()];
        Iterator iterator2 = this.initialVertices.iterator();
        int n = 0;
        while (true) {
            if (!iterator2.hasNext()) {
                iterator2 = this.segVertices.iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        return coordinateArray;
                    }
                    coordinateArray[n] = ((Vertex)iterator2.next()).getCoordinate();
                    ++n;
                }
            }
            coordinateArray[n] = ((Vertex)iterator2.next()).getCoordinate();
            ++n;
        }
    }

    private ConstraintVertex insertSite(ConstraintVertex constraintVertex) {
        Object object = this.kdt.insert(constraintVertex.getCoordinate(), constraintVertex);
        if (!((KdNode)object).isRepeated()) {
            this.incDel.insertSite(constraintVertex);
            return constraintVertex;
        }
        object = (ConstraintVertex)((KdNode)object).getData();
        ((ConstraintVertex)object).merge(constraintVertex);
        return object;
    }

    private void insertSites(Collection object) {
        StringBuilder stringBuilder = new StringBuilder("Adding sites: ");
        stringBuilder.append(object.size());
        Debug.println(stringBuilder.toString());
        object = object.iterator();
        while (object.hasNext()) {
            this.insertSite((ConstraintVertex)object.next());
        }
        return;
    }

    public void enforceConstraints() {
        int n;
        this.addConstraintVertices();
        int n2 = 0;
        do {
            int n3 = this.enforceGabriel(this.segments);
            n = n2 + 1;
            StringBuilder stringBuilder = new StringBuilder("Iter: ");
            stringBuilder.append(n);
            stringBuilder.append("   Splits: ");
            stringBuilder.append(n3);
            stringBuilder.append("   Current # segments = ");
            stringBuilder.append(this.segments.size());
            Debug.println(stringBuilder.toString());
            if (n3 <= 0) break;
            n2 = n;
        } while (n < 99);
        if (n == 99) {
            Debug.println("ABORTED! Too many iterations while enforcing constraints");
            if (!Debug.isDebugging()) {
                throw new ConstraintEnforcementException("Too many splitting iterations while enforcing constraints.  Last split point was at: ", this.splitPt);
            }
        }
    }

    public void formInitialDelaunay() {
        QuadEdgeSubdivision quadEdgeSubdivision;
        this.computeBoundingBox();
        this.subdiv = quadEdgeSubdivision = new QuadEdgeSubdivision(this.computeAreaEnv, this.tolerance);
        quadEdgeSubdivision.setLocator(new LastFoundQuadEdgeLocator(quadEdgeSubdivision));
        this.incDel = new IncrementalDelaunayTriangulator(this.subdiv);
        this.insertSites(this.initialVertices);
    }

    public Collection getConstraintSegments() {
        return this.segments;
    }

    public Geometry getConvexHull() {
        return this.convexHull;
    }

    public List getInitialVertices() {
        return this.initialVertices;
    }

    public KdTree getKDT() {
        return this.kdt;
    }

    public QuadEdgeSubdivision getSubdivision() {
        return this.subdiv;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public ConstraintVertexFactory getVertexFactory() {
        return this.vertexFactory;
    }

    public void insertSite(Coordinate coordinate) {
        this.insertSite(this.createVertex(coordinate));
    }

    public void setConstraints(List list, List list2) {
        this.segments = list;
        this.segVertices = list2;
    }

    public void setSplitPointFinder(ConstraintSplitPointFinder constraintSplitPointFinder) {
        this.splitFinder = constraintSplitPointFinder;
    }

    public void setVertexFactory(ConstraintVertexFactory constraintVertexFactory) {
        this.vertexFactory = constraintVertexFactory;
    }
}

