/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.triangulate.IncrementalDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DelaunayTriangulationBuilder {
    private Collection siteCoords;
    private QuadEdgeSubdivision subdiv = null;
    private double tolerance = 0.0;

    private void create() {
        if (this.subdiv != null) {
            return;
        }
        Object object = DelaunayTriangulationBuilder.envelope(this.siteCoords);
        List list = DelaunayTriangulationBuilder.toVertices(this.siteCoords);
        this.subdiv = object = new QuadEdgeSubdivision((Envelope)object, this.tolerance);
        new IncrementalDelaunayTriangulator((QuadEdgeSubdivision)object).insertSites(list);
    }

    public static Envelope envelope(Collection object) {
        Envelope envelope = new Envelope();
        object = object.iterator();
        while (object.hasNext()) {
            envelope.expandToInclude((Coordinate)object.next());
        }
        return envelope;
    }

    public static CoordinateList extractUniqueCoordinates(Geometry geometry) {
        if (geometry == null) {
            return new CoordinateList();
        }
        return DelaunayTriangulationBuilder.unique(geometry.getCoordinates());
    }

    public static List toVertices(Collection object) {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(new Vertex((Coordinate)object.next()));
        }
        return arrayList;
    }

    public static CoordinateList unique(Coordinate[] coordinateArray) {
        coordinateArray = CoordinateArrays.copyDeep(coordinateArray);
        Arrays.sort(coordinateArray);
        return new CoordinateList(coordinateArray, false);
    }

    public Geometry getEdges(GeometryFactory geometryFactory) {
        this.create();
        return this.subdiv.getEdges(geometryFactory);
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public Geometry getTriangles(GeometryFactory geometryFactory) {
        this.create();
        return this.subdiv.getTriangles(geometryFactory);
    }

    public void setSites(Geometry geometry) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geometry);
    }

    public void setSites(Collection collection) {
        this.siteCoords = DelaunayTriangulationBuilder.unique(CoordinateArrays.toCoordinateArray(collection));
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }
}

