/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;

public class SplitSegment {
    private double minimumLen = 0.0;
    private LineSegment seg;
    private double segLen;
    private Coordinate splitPt;

    public SplitSegment(LineSegment lineSegment) {
        this.seg = lineSegment;
        this.segLen = lineSegment.getLength();
    }

    private double getConstrainedLength(double d) {
        double d2 = this.minimumLen;
        if (d < d2) {
            return d2;
        }
        return d;
    }

    private static Coordinate pointAlongReverse(LineSegment lineSegment, double d) {
        Coordinate coordinate = new Coordinate();
        coordinate.x = lineSegment.p1.x - (lineSegment.p1.x - lineSegment.p0.x) * d;
        coordinate.y = lineSegment.p1.y - d * (lineSegment.p1.y - lineSegment.p0.y);
        return coordinate;
    }

    public Coordinate getSplitPoint() {
        return this.splitPt;
    }

    public void setMinimumLength(double d) {
        this.minimumLen = d;
    }

    public void splitAt(double d, Coordinate coordinate) {
        d = this.getConstrainedLength(d) / this.segLen;
        this.splitPt = coordinate.equals2D(this.seg.p0) ? this.seg.pointAlong(d) : SplitSegment.pointAlongReverse(this.seg, d);
    }

    public void splitAt(Coordinate coordinate) {
        double d = this.minimumLen / this.segLen;
        if (coordinate.distance(this.seg.p0) < this.minimumLen) {
            this.splitPt = this.seg.pointAlong(d);
            return;
        }
        if (coordinate.distance(this.seg.p1) < this.minimumLen) {
            this.splitPt = SplitSegment.pointAlongReverse(this.seg, d);
            return;
        }
        this.splitPt = coordinate;
    }
}

