/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class VertexTaggedGeometryDataMapper {
    private Map coordDataMap = new TreeMap();

    private void loadVertices(Coordinate[] coordinateArray, Object object) {
        int n = 0;
        while (n < coordinateArray.length) {
            this.coordDataMap.put(coordinateArray[n], object);
            ++n;
        }
        return;
    }

    public List getCoordinates() {
        return new ArrayList(this.coordDataMap.keySet());
    }

    public void loadSourceGeometries(Geometry geometry) {
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            Geometry geometry2 = geometry.getGeometryN(n);
            this.loadVertices(geometry2.getCoordinates(), geometry2.getUserData());
            ++n;
        }
        return;
    }

    public void loadSourceGeometries(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            Geometry geometry = (Geometry)object.next();
            this.loadVertices(geometry.getCoordinates(), geometry.getUserData());
        }
        return;
    }

    public void transferData(Geometry geometry) {
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            Geometry geometry2 = geometry.getGeometryN(n);
            Coordinate coordinate = (Coordinate)geometry2.getUserData();
            if (coordinate != null) {
                geometry2.setUserData(this.coordDataMap.get(coordinate));
            }
            ++n;
        }
        return;
    }
}

