/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;

public class QuadEdge {
    private Object data = null;
    private QuadEdge next;
    private QuadEdge rot;
    private Vertex vertex;

    private QuadEdge() {
    }

    public static QuadEdge connect(QuadEdge quadEdge, QuadEdge quadEdge2) {
        QuadEdge quadEdge3 = QuadEdge.makeEdge(quadEdge.dest(), quadEdge2.orig());
        QuadEdge.splice(quadEdge3, quadEdge.lNext());
        QuadEdge.splice(quadEdge3.sym(), quadEdge2);
        return quadEdge3;
    }

    public static QuadEdge makeEdge(Vertex vertex, Vertex vertex2) {
        QuadEdge quadEdge = new QuadEdge();
        QuadEdge quadEdge2 = new QuadEdge();
        QuadEdge quadEdge3 = new QuadEdge();
        QuadEdge quadEdge4 = new QuadEdge();
        quadEdge.rot = quadEdge2;
        quadEdge2.rot = quadEdge3;
        quadEdge3.rot = quadEdge4;
        quadEdge4.rot = quadEdge;
        quadEdge.setNext(quadEdge);
        quadEdge2.setNext(quadEdge4);
        quadEdge3.setNext(quadEdge3);
        quadEdge4.setNext(quadEdge2);
        quadEdge.setOrig(vertex);
        quadEdge.setDest(vertex2);
        return quadEdge;
    }

    public static void splice(QuadEdge quadEdge, QuadEdge quadEdge2) {
        QuadEdge quadEdge3 = quadEdge.oNext().rot();
        QuadEdge quadEdge4 = quadEdge2.oNext().rot();
        QuadEdge quadEdge5 = quadEdge2.oNext();
        QuadEdge quadEdge6 = quadEdge.oNext();
        QuadEdge quadEdge7 = quadEdge4.oNext();
        QuadEdge quadEdge8 = quadEdge3.oNext();
        quadEdge.setNext(quadEdge5);
        quadEdge2.setNext(quadEdge6);
        quadEdge3.setNext(quadEdge7);
        quadEdge4.setNext(quadEdge8);
    }

    public static void swap(QuadEdge quadEdge) {
        QuadEdge quadEdge2 = quadEdge.oPrev();
        QuadEdge quadEdge3 = quadEdge.sym().oPrev();
        QuadEdge.splice(quadEdge, quadEdge2);
        QuadEdge.splice(quadEdge.sym(), quadEdge3);
        QuadEdge.splice(quadEdge, quadEdge2.lNext());
        QuadEdge.splice(quadEdge.sym(), quadEdge3.lNext());
        quadEdge.setOrig(quadEdge2.dest());
        quadEdge.setDest(quadEdge3.dest());
    }

    public final QuadEdge dNext() {
        return this.sym().oNext().sym();
    }

    public final QuadEdge dPrev() {
        return this.invRot().oNext().invRot();
    }

    public void delete() {
        this.rot = null;
    }

    public final Vertex dest() {
        return this.sym().orig();
    }

    public boolean equalsNonOriented(QuadEdge quadEdge) {
        if (this.equalsOriented(quadEdge)) {
            return true;
        }
        return this.equalsOriented(quadEdge.sym());
    }

    public boolean equalsOriented(QuadEdge quadEdge) {
        return this.orig().getCoordinate().equals2D(quadEdge.orig().getCoordinate()) && this.dest().getCoordinate().equals2D(quadEdge.dest().getCoordinate());
    }

    public Object getData() {
        return this.data;
    }

    public double getLength() {
        return this.orig().getCoordinate().distance(this.dest().getCoordinate());
    }

    public QuadEdge getPrimary() {
        if (this.orig().getCoordinate().compareTo(this.dest().getCoordinate()) <= 0) {
            return this;
        }
        return this.sym();
    }

    public final QuadEdge invRot() {
        return this.rot.sym();
    }

    public boolean isLive() {
        return this.rot != null;
    }

    public final QuadEdge lNext() {
        return this.invRot().oNext().rot();
    }

    public final QuadEdge lPrev() {
        return this.next.sym();
    }

    public final QuadEdge oNext() {
        return this.next;
    }

    public final QuadEdge oPrev() {
        return this.rot.next.rot;
    }

    public final Vertex orig() {
        return this.vertex;
    }

    public final QuadEdge rNext() {
        return this.rot.next.invRot();
    }

    public final QuadEdge rPrev() {
        return this.sym().oNext();
    }

    public final QuadEdge rot() {
        return this.rot;
    }

    public void setData(Object object) {
        this.data = object;
    }

    void setDest(Vertex vertex) {
        this.sym().setOrig(vertex);
    }

    public void setNext(QuadEdge quadEdge) {
        this.next = quadEdge;
    }

    void setOrig(Vertex vertex) {
        this.vertex = vertex;
    }

    public final QuadEdge sym() {
        return this.rot.rot;
    }

    public LineSegment toLineSegment() {
        return new LineSegment(this.vertex.getCoordinate(), this.dest().getCoordinate());
    }

    public String toString() {
        return WKTWriter.toLineString(this.vertex.getCoordinate(), this.dest().getCoordinate());
    }
}

