/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.TriangleVisitor;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.List;

public class QuadEdgeTriangle {
    private Object data;
    private QuadEdge[] edge;

    public QuadEdgeTriangle(QuadEdge[] quadEdgeArray) {
        this.edge = (QuadEdge[])quadEdgeArray.clone();
        int n = 0;
        while (n < 3) {
            quadEdgeArray[n].setData(this);
            ++n;
        }
        return;
    }

    public static boolean contains(QuadEdge[] quadEdgeArray, Coordinate coordinate) {
        return CGAlgorithms.isPointInRing(coordinate, new Coordinate[]{quadEdgeArray[0].orig().getCoordinate(), quadEdgeArray[1].orig().getCoordinate(), quadEdgeArray[2].orig().getCoordinate(), quadEdgeArray[0].orig().getCoordinate()});
    }

    public static boolean contains(Vertex[] vertexArray, Coordinate coordinate) {
        return CGAlgorithms.isPointInRing(coordinate, new Coordinate[]{vertexArray[0].getCoordinate(), vertexArray[1].getCoordinate(), vertexArray[2].getCoordinate(), vertexArray[0].getCoordinate()});
    }

    public static List createOn(QuadEdgeSubdivision quadEdgeSubdivision) {
        QuadEdgeTriangleBuilderVisitor quadEdgeTriangleBuilderVisitor = new QuadEdgeTriangleBuilderVisitor();
        quadEdgeSubdivision.visitTriangles(quadEdgeTriangleBuilderVisitor, false);
        return quadEdgeTriangleBuilderVisitor.getTriangles();
    }

    public static int nextIndex(int n) {
        return (n + 1) % 3;
    }

    public static Geometry toPolygon(QuadEdge[] object) {
        Coordinate coordinate = object[0].orig().getCoordinate();
        Coordinate coordinate2 = object[1].orig().getCoordinate();
        Coordinate coordinate3 = object[2].orig().getCoordinate();
        Coordinate coordinate4 = object[0].orig().getCoordinate();
        object = new GeometryFactory();
        return ((GeometryFactory)object).createPolygon(((GeometryFactory)object).createLinearRing(new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4}), null);
    }

    public static Geometry toPolygon(Vertex[] object) {
        Coordinate coordinate = object[0].getCoordinate();
        Coordinate coordinate2 = object[1].getCoordinate();
        Coordinate coordinate3 = object[2].getCoordinate();
        Coordinate coordinate4 = object[0].getCoordinate();
        object = new GeometryFactory();
        return ((GeometryFactory)object).createPolygon(((GeometryFactory)object).createLinearRing(new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4}), null);
    }

    public boolean contains(Coordinate coordinate) {
        return CGAlgorithms.isPointInRing(coordinate, this.getCoordinates());
    }

    public QuadEdgeTriangle getAdjacentTriangleAcrossEdge(int n) {
        return (QuadEdgeTriangle)this.getEdge(n).sym().getData();
    }

    public int getAdjacentTriangleEdgeIndex(int n) {
        return this.getAdjacentTriangleAcrossEdge(n).getEdgeIndex(this.getEdge(n).sym());
    }

    public Coordinate getCoordinate(int n) {
        return this.edge[n].orig().getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray = new Coordinate[4];
        int n = 0;
        while (true) {
            if (n >= 3) {
                coordinateArray[3] = new Coordinate(coordinateArray[0]);
                return coordinateArray;
            }
            coordinateArray[n] = this.edge[n].orig().getCoordinate();
            ++n;
        }
    }

    public Object getData() {
        return this.data;
    }

    public QuadEdge getEdge(int n) {
        return this.edge[n];
    }

    public int getEdgeIndex(QuadEdge quadEdge) {
        int n = 0;
        while (n < 3) {
            if (this.edge[n] == quadEdge) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getEdgeIndex(Vertex vertex) {
        int n = 0;
        while (n < 3) {
            if (this.edge[n].orig() == vertex) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void getEdgeSegment(int n, LineSegment lineSegment) {
        lineSegment.p0 = this.edge[n].orig().getCoordinate();
        lineSegment.p1 = this.edge[(n + 1) % 3].orig().getCoordinate();
    }

    public QuadEdge[] getEdges() {
        return this.edge;
    }

    public Polygon getGeometry(GeometryFactory geometryFactory) {
        return geometryFactory.createPolygon(geometryFactory.createLinearRing(this.getCoordinates()), null);
    }

    public QuadEdgeTriangle[] getNeighbours() {
        QuadEdgeTriangle[] quadEdgeTriangleArray = new QuadEdgeTriangle[3];
        int n = 0;
        while (n < 3) {
            quadEdgeTriangleArray[n] = (QuadEdgeTriangle)this.getEdge(n).sym().getData();
            ++n;
        }
        return quadEdgeTriangleArray;
    }

    public List getTrianglesAdjacentToVertex(int n) {
        Object object;
        ArrayList<QuadEdgeTriangle> arrayList = new ArrayList<QuadEdgeTriangle>();
        QuadEdge quadEdge = this.getEdge(n);
        Object object2 = quadEdge;
        do {
            if ((object = (QuadEdgeTriangle)((QuadEdge)object2).getData()) != null) {
                arrayList.add((QuadEdgeTriangle)object);
            }
            object2 = object = ((QuadEdge)object2).oNext();
        } while (object != quadEdge);
        return arrayList;
    }

    public Vertex getVertex(int n) {
        return this.edge[n].orig();
    }

    public Vertex[] getVertices() {
        Vertex[] vertexArray = new Vertex[3];
        int n = 0;
        while (n < 3) {
            vertexArray[n] = this.getVertex(n);
            ++n;
        }
        return vertexArray;
    }

    public boolean isBorder() {
        int n = 0;
        while (n < 3) {
            if (this.getAdjacentTriangleAcrossEdge(n) == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isBorder(int n) {
        return this.getAdjacentTriangleAcrossEdge(n) == null;
    }

    public boolean isLive() {
        return this.edge != null;
    }

    public void kill() {
        this.edge = null;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public String toString() {
        return this.getGeometry(new GeometryFactory()).toString();
    }

    private static class QuadEdgeTriangleBuilderVisitor
    implements TriangleVisitor {
        private List triangles = new ArrayList();

        public List getTriangles() {
            return this.triangles;
        }

        @Override
        public void visit(QuadEdge[] quadEdgeArray) {
            this.triangles.add(new QuadEdgeTriangle(quadEdgeArray));
        }
    }
}

