/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.math.DD;
import java.io.PrintStream;

public class TrianglePredicate {
    private static void checkRobustInCircle(Coordinate object, Coordinate comparable, Coordinate coordinate, Coordinate coordinate2) {
        boolean bl = TrianglePredicate.isInCircleNonRobust((Coordinate)object, (Coordinate)comparable, coordinate, coordinate2);
        boolean bl2 = TrianglePredicate.isInCircleDDSlow((Coordinate)object, (Coordinate)comparable, coordinate, coordinate2);
        boolean bl3 = TrianglePredicate.isInCircleCC((Coordinate)object, (Coordinate)comparable, coordinate, coordinate2);
        Coordinate coordinate3 = Triangle.circumcentre((Coordinate)object, (Coordinate)comparable, coordinate);
        PrintStream printStream = System.out;
        StringBuilder stringBuilder = new StringBuilder("p radius diff a = ");
        stringBuilder.append(Math.abs(coordinate2.distance(coordinate3) - ((Coordinate)object).distance(coordinate3)) / ((Coordinate)object).distance(coordinate3));
        printStream.println(stringBuilder.toString());
        if (bl != bl2 || bl != bl3) {
            printStream = System.out;
            stringBuilder = new StringBuilder("inCircle robustness failure (double result = ");
            stringBuilder.append(bl);
            stringBuilder.append(", DD result = ");
            stringBuilder.append(bl2);
            stringBuilder.append(", CC result = ");
            stringBuilder.append(bl3);
            stringBuilder.append(")");
            printStream.println(stringBuilder.toString());
            System.out.println(WKTWriter.toLineString(new CoordinateArraySequence(new Coordinate[]{object, comparable, coordinate, coordinate2})));
            printStream = System.out;
            stringBuilder = new StringBuilder("Circumcentre = ");
            stringBuilder.append(WKTWriter.toPoint(coordinate3));
            stringBuilder.append(" radius = ");
            stringBuilder.append(((Coordinate)object).distance(coordinate3));
            printStream.println(stringBuilder.toString());
            printStream = System.out;
            stringBuilder = new StringBuilder("p radius diff a = ");
            stringBuilder.append(Math.abs(coordinate2.distance(coordinate3) / ((Coordinate)object).distance(coordinate3) - 1.0));
            printStream.println(stringBuilder.toString());
            printStream = System.out;
            object = new StringBuilder("p radius diff b = ");
            ((StringBuilder)object).append(Math.abs(coordinate2.distance(coordinate3) / ((Coordinate)comparable).distance(coordinate3) - 1.0));
            printStream.println(((StringBuilder)object).toString());
            object = System.out;
            comparable = new StringBuilder("p radius diff c = ");
            ((StringBuilder)comparable).append(Math.abs(coordinate2.distance(coordinate3) / coordinate.distance(coordinate3) - 1.0));
            ((PrintStream)object).println(((StringBuilder)comparable).toString());
            System.out.println();
        }
    }

    public static boolean isInCircleCC(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        coordinate2 = Triangle.circumcentre(coordinate, coordinate2, coordinate3);
        double d = coordinate.distance(coordinate2);
        return coordinate4.distance(coordinate2) - d <= 0.0;
    }

    public static boolean isInCircleDDFast(Coordinate comparable, Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        DD dD = DD.sqr(comparable.x).selfAdd(DD.sqr(comparable.y)).selfMultiply(TrianglePredicate.triAreaDDFast(coordinate, coordinate2, coordinate3));
        DD dD2 = DD.sqr(coordinate.x).selfAdd(DD.sqr(coordinate.y)).selfMultiply(TrianglePredicate.triAreaDDFast(comparable, coordinate2, coordinate3));
        DD dD3 = DD.sqr(coordinate2.x).selfAdd(DD.sqr(coordinate2.y)).selfMultiply(TrianglePredicate.triAreaDDFast(comparable, coordinate, coordinate3));
        comparable = DD.sqr(coordinate3.x).selfAdd(DD.sqr(coordinate3.y)).selfMultiply(TrianglePredicate.triAreaDDFast(comparable, coordinate, coordinate2));
        boolean bl = dD.selfSubtract(dD2).selfAdd(dD3).selfSubtract((DD)comparable).doubleValue() > 0.0;
        return bl;
    }

    public static boolean isInCircleDDNormalized(Coordinate comparable, Coordinate comparable2, Coordinate comparable3, Coordinate comparable4) {
        DD dD = DD.valueOf(((Coordinate)comparable).x).selfSubtract(comparable4.x);
        DD dD2 = DD.valueOf(((Coordinate)comparable).y).selfSubtract(comparable4.y);
        DD dD3 = DD.valueOf(comparable2.x).selfSubtract(comparable4.x);
        DD dD4 = DD.valueOf(comparable2.y).selfSubtract(comparable4.y);
        comparable = DD.valueOf(comparable3.x).selfSubtract(comparable4.x);
        DD dD5 = DD.valueOf(comparable3.y).selfSubtract(comparable4.y);
        comparable4 = dD.multiply(dD4).selfSubtract(dD3.multiply(dD2));
        comparable2 = dD3.multiply(dD5).selfSubtract(((DD)comparable).multiply(dD4));
        comparable3 = ((DD)comparable).multiply(dD2).selfSubtract(dD.multiply(dD5));
        dD = dD.multiply(dD).selfAdd(dD2.multiply(dD2));
        dD3 = dD3.multiply(dD3).selfAdd(dD4.multiply(dD4));
        comparable = ((DD)comparable).multiply((DD)comparable).selfAdd(dD5.multiply(dD5));
        boolean bl = dD.selfMultiply((DD)comparable2).selfAdd(dD3.selfMultiply((DD)comparable3)).selfAdd(((DD)comparable).selfMultiply((DD)comparable4)).doubleValue() > 0.0;
        return bl;
    }

    public static boolean isInCircleDDSlow(Coordinate comparable, Coordinate comparable2, Coordinate comparable3, Coordinate comparable4) {
        DD dD = DD.valueOf(((Coordinate)comparable4).x);
        comparable4 = DD.valueOf(((Coordinate)comparable4).y);
        DD dD2 = DD.valueOf(((Coordinate)comparable).x);
        DD dD3 = DD.valueOf(((Coordinate)comparable).y);
        comparable = DD.valueOf(comparable2.x);
        DD dD4 = DD.valueOf(comparable2.y);
        DD dD5 = DD.valueOf(comparable3.x);
        DD dD6 = DD.valueOf(comparable3.y);
        DD dD7 = dD2.multiply(dD2).add(dD3.multiply(dD3)).multiply(TrianglePredicate.triAreaDDSlow((DD)comparable, dD4, dD5, dD6, dD, (DD)comparable4));
        comparable2 = ((DD)comparable).multiply((DD)comparable).add(dD4.multiply(dD4)).multiply(TrianglePredicate.triAreaDDSlow(dD2, dD3, dD5, dD6, dD, (DD)comparable4));
        comparable3 = dD5.multiply(dD5).add(dD6.multiply(dD6)).multiply(TrianglePredicate.triAreaDDSlow(dD2, dD3, (DD)comparable, dD4, dD, (DD)comparable4));
        comparable = dD.multiply(dD).add(((DD)comparable4).multiply((DD)comparable4)).multiply(TrianglePredicate.triAreaDDSlow(dD2, dD3, (DD)comparable, dD4, dD5, dD6));
        boolean bl = dD7.subtract((DD)comparable2).add((DD)comparable3).subtract((DD)comparable).doubleValue() > 0.0;
        return bl;
    }

    public static boolean isInCircleNonRobust(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        boolean bl = (coordinate.x * coordinate.x + coordinate.y * coordinate.y) * TrianglePredicate.triArea(coordinate2, coordinate3, coordinate4) - (coordinate2.x * coordinate2.x + coordinate2.y * coordinate2.y) * TrianglePredicate.triArea(coordinate, coordinate3, coordinate4) + (coordinate3.x * coordinate3.x + coordinate3.y * coordinate3.y) * TrianglePredicate.triArea(coordinate, coordinate2, coordinate4) - (coordinate4.x * coordinate4.x + coordinate4.y * coordinate4.y) * TrianglePredicate.triArea(coordinate, coordinate2, coordinate3) > 0.0;
        return bl;
    }

    public static boolean isInCircleNormalized(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d = coordinate.x - coordinate4.x;
        double d2 = coordinate.y - coordinate4.y;
        double d3 = coordinate2.x - coordinate4.x;
        double d4 = coordinate3.y - coordinate4.y;
        double d5 = coordinate3.x - coordinate4.x;
        double d6 = coordinate2.y - coordinate4.y;
        return (d * d + d2 * d2) * (d3 * d4 - d5 * d6) + (d3 * d3 + d6 * d6) * (d5 * d2 - d * d4) + (d5 * d5 + d4 * d4) * (d * d6 - d3 * d2) > 0.0;
    }

    public static boolean isInCircleRobust(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        return TrianglePredicate.isInCircleNormalized(coordinate, coordinate2, coordinate3, coordinate4);
    }

    private static double triArea(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate.y) - (coordinate2.y - coordinate.y) * (coordinate3.x - coordinate.x);
    }

    public static DD triAreaDDFast(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return DD.valueOf(coordinate2.x).selfSubtract(coordinate.x).selfMultiply(DD.valueOf(coordinate3.y).selfSubtract(coordinate.y)).selfSubtract(DD.valueOf(coordinate2.y).selfSubtract(coordinate.y).selfMultiply(DD.valueOf(coordinate3.x).selfSubtract(coordinate.x)));
    }

    public static DD triAreaDDSlow(DD dD, DD dD2, DD dD3, DD dD4, DD dD5, DD dD6) {
        return dD3.subtract(dD).multiply(dD6.subtract(dD2)).subtract(dD4.subtract(dD2).multiply(dD5.subtract(dD)));
    }
}

