/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.TrianglePredicate;
import java.io.PrintStream;

public class Vertex {
    public static final int BEHIND = 3;
    public static final int BETWEEN = 4;
    public static final int BEYOND = 2;
    public static final int DESTINATION = 6;
    public static final int LEFT = 0;
    public static final int ORIGIN = 5;
    public static final int RIGHT = 1;
    private Coordinate p;

    public Vertex(double d, double d2) {
        this.p = new Coordinate(d, d2);
    }

    public Vertex(double d, double d2, double d3) {
        this.p = new Coordinate(d, d2, d3);
    }

    public Vertex(Coordinate coordinate) {
        this.p = new Coordinate(coordinate);
    }

    private HCoordinate bisector(Vertex vertex, Vertex vertex2) {
        double d = vertex2.getX() - vertex.getX();
        double d2 = vertex2.getY() - vertex.getY();
        double d3 = vertex.getX();
        double d4 = d / 2.0;
        double d5 = vertex.getY();
        double d6 = d2 / 2.0;
        return new HCoordinate(new HCoordinate(d3 + d4, d5 + d6, 1.0), new HCoordinate(vertex.getX() - d2 + d4, vertex.getY() + d + d6, 1.0));
    }

    private double distance(Vertex vertex, Vertex vertex2) {
        return Math.sqrt(Math.pow(vertex2.getX() - vertex.getX(), 2.0) + Math.pow(vertex2.getY() - vertex.getY(), 2.0));
    }

    public static double interpolateZ(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate2.distance(coordinate3);
        double d2 = coordinate.distance(coordinate2);
        double d3 = coordinate3.z;
        double d4 = coordinate2.z;
        return coordinate2.z + (d3 - d4) * (d2 / d);
    }

    public static double interpolateZ(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d = coordinate2.x;
        double d2 = coordinate2.y;
        double d3 = coordinate3.x - d;
        double d4 = coordinate4.x - d;
        double d5 = coordinate3.y - d2;
        double d6 = coordinate4.y - d2;
        double d7 = d3 * d6 - d4 * d5;
        d = coordinate.x - d;
        d2 = coordinate.y - d2;
        d4 = (d6 * d - d4 * d2) / d7;
        d5 = (-d5 * d + d3 * d2) / d7;
        return coordinate2.z + d4 * (coordinate3.z - coordinate2.z) + d5 * (coordinate4.z - coordinate2.z);
    }

    public Vertex circleCenter(Vertex vertex, Vertex vertex2) {
        Vertex vertex3 = new Vertex(this.getX(), this.getY());
        HCoordinate hCoordinate = new HCoordinate(this.bisector(vertex3, vertex), this.bisector(vertex, vertex2));
        try {
            Vertex vertex4;
            vertex = vertex4 = new Vertex(hCoordinate.getX(), hCoordinate.getY());
        }
        catch (NotRepresentableException notRepresentableException) {
            PrintStream printStream = System.err;
            StringBuilder stringBuilder = new StringBuilder("a: ");
            stringBuilder.append(vertex3);
            stringBuilder.append("  b: ");
            stringBuilder.append(vertex);
            stringBuilder.append("  c: ");
            stringBuilder.append(vertex2);
            printStream.println(stringBuilder.toString());
            System.err.println(notRepresentableException);
            vertex = null;
        }
        return vertex;
    }

    public double circumRadiusRatio(Vertex vertex, Vertex vertex2) {
        double d = this.distance(this.circleCenter(vertex, vertex2), vertex);
        double d2 = this.distance(this, vertex);
        double d3 = this.distance(vertex, vertex2);
        double d4 = d2;
        if (d3 < d2) {
            d4 = d3;
        }
        d3 = this.distance(vertex2, this);
        d2 = d4;
        if (d3 < d4) {
            d2 = d3;
        }
        return d / d2;
    }

    public int classify(Vertex vertex, Vertex vertex2) {
        Vertex vertex3;
        Vertex vertex4 = vertex2.sub(vertex);
        double d = vertex4.crossProduct(vertex3 = this.sub(vertex));
        if (d > 0.0) {
            return 0;
        }
        if (d < 0.0) {
            return 1;
        }
        if (!(vertex4.getX() * vertex3.getX() < 0.0) && !(vertex4.getY() * vertex3.getY() < 0.0)) {
            if (vertex4.magn() < vertex3.magn()) {
                return 2;
            }
            if (vertex.equals(this)) {
                return 5;
            }
            if (vertex2.equals(this)) {
                return 6;
            }
            return 4;
        }
        return 3;
    }

    Vertex cross() {
        return new Vertex(this.p.y, -this.p.x);
    }

    double crossProduct(Vertex vertex) {
        return this.p.x * vertex.getY() - this.p.y * vertex.getX();
    }

    double dot(Vertex vertex) {
        return this.p.x * vertex.getX() + this.p.y * vertex.getY();
    }

    public boolean equals(Vertex vertex) {
        return this.p.x == vertex.getX() && this.p.y == vertex.getY();
    }

    public boolean equals(Vertex vertex, double d) {
        return this.p.distance(vertex.getCoordinate()) < d;
    }

    public Coordinate getCoordinate() {
        return this.p;
    }

    public double getX() {
        return this.p.x;
    }

    public double getY() {
        return this.p.y;
    }

    public double getZ() {
        return this.p.z;
    }

    public double interpolateZValue(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        double d = vertex.getX();
        double d2 = vertex.getY();
        double d3 = vertex2.getX() - d;
        double d4 = vertex3.getX() - d;
        double d5 = vertex2.getY() - d2;
        double d6 = vertex3.getY() - d2;
        double d7 = d3 * d6 - d4 * d5;
        d = this.getX() - d;
        d2 = this.getY() - d2;
        d6 = (d6 * d - d4 * d2) / d7;
        d3 = (-d5 * d + d3 * d2) / d7;
        return vertex.getZ() + d6 * (vertex2.getZ() - vertex.getZ()) + d3 * (vertex3.getZ() - vertex.getZ());
    }

    public final boolean isCCW(Vertex vertex, Vertex vertex2) {
        return (vertex.p.x - this.p.x) * (vertex2.p.y - this.p.y) - (vertex.p.y - this.p.y) * (vertex2.p.x - this.p.x) > 0.0;
    }

    public boolean isInCircle(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        return TrianglePredicate.isInCircleRobust(vertex.p, vertex2.p, vertex3.p, this.p);
    }

    public final boolean leftOf(QuadEdge quadEdge) {
        return this.isCCW(quadEdge.orig(), quadEdge.dest());
    }

    double magn() {
        return Math.sqrt(this.p.x * this.p.x + this.p.y * this.p.y);
    }

    public Vertex midPoint(Vertex vertex) {
        return new Vertex((this.p.x + vertex.getX()) / 2.0, (this.p.y + vertex.getY()) / 2.0, (this.p.z + vertex.getZ()) / 2.0);
    }

    public final boolean rightOf(QuadEdge quadEdge) {
        return this.isCCW(quadEdge.dest(), quadEdge.orig());
    }

    public void setZ(double d) {
        this.p.z = d;
    }

    Vertex sub(Vertex vertex) {
        return new Vertex(this.p.x - vertex.getX(), this.p.y - vertex.getY());
    }

    Vertex sum(Vertex vertex) {
        return new Vertex(this.p.x + vertex.getX(), this.p.y + vertex.getY());
    }

    Vertex times(double d) {
        return new Vertex(this.p.x * d, d * this.p.y);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("POINT (");
        stringBuilder.append(this.p.x);
        stringBuilder.append(" ");
        stringBuilder.append(this.p.y);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

