/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;

public class GeometricShapeFactory {
    protected Dimensions dim = new Dimensions();
    protected GeometryFactory geomFact;
    protected int nPts = 100;
    protected PrecisionModel precModel = null;
    protected double rotationAngle = 0.0;

    public GeometricShapeFactory() {
        this(new GeometryFactory());
    }

    public GeometricShapeFactory(GeometryFactory geometryFactory) {
        this.geomFact = geometryFactory;
        this.precModel = geometryFactory.getPrecisionModel();
    }

    protected Coordinate coord(double d, double d2) {
        Coordinate coordinate = new Coordinate(d, d2);
        this.precModel.makePrecise(coordinate);
        return coordinate;
    }

    protected Coordinate coordTrans(double d, double d2, Coordinate coordinate) {
        return this.coord(d + coordinate.x, d2 + coordinate.y);
    }

    public LineString createArc(double d, double d2) {
        double d3;
        Coordinate[] coordinateArray = this.dim.getEnvelope();
        double d4 = coordinateArray.getWidth() / 2.0;
        double d5 = coordinateArray.getHeight() / 2.0;
        double d6 = coordinateArray.getMinX();
        double d7 = coordinateArray.getMinY();
        double d8 = d3 = Math.PI * 2;
        if (!(d2 <= 0.0)) {
            d8 = d2 > Math.PI * 2 ? d3 : d2;
        }
        int n = this.nPts;
        d8 /= (double)(n - 1);
        coordinateArray = new Coordinate[n];
        int n2 = 0;
        n = 0;
        d2 = d4;
        while (n2 < this.nPts) {
            d3 = d + (double)n2 * d8;
            coordinateArray[n] = this.coord(Math.cos(d3) * d2 + (d6 + d4), Math.sin(d3) * d5 + (d7 + d5));
            ++n2;
            ++n;
        }
        return (LineString)this.rotate(this.geomFact.createLineString(coordinateArray));
    }

    public Polygon createArcPolygon(double d, double d2) {
        double d3;
        Object object = this.dim.getEnvelope();
        double d4 = object.getWidth() / 2.0;
        double d5 = object.getHeight() / 2.0;
        double d6 = object.getMinX() + d4;
        double d7 = object.getMinY() + d5;
        double d8 = d3 = Math.PI * 2;
        if (!(d2 <= 0.0)) {
            d8 = d2 > Math.PI * 2 ? d3 : d2;
        }
        int n = this.nPts;
        d8 /= (double)(n - 1);
        object = new Coordinate[n + 2];
        Coordinate coordinate = this.coord(d6, d7);
        n = 0;
        object[0] = coordinate;
        int n2 = 1;
        d2 = d4;
        while (true) {
            if (n >= this.nPts) {
                object[n2] = this.coord(d6, d7);
                object = this.geomFact.createLinearRing((Coordinate[])object);
                return (Polygon)this.rotate(this.geomFact.createPolygon((LinearRing)object, null));
            }
            d4 = d + (double)n * d8;
            object[n2] = this.coord(Math.cos(d4) * d2 + d6, Math.sin(d4) * d5 + d7);
            ++n;
            ++n2;
        }
    }

    public Polygon createCircle() {
        return this.createEllipse();
    }

    public Polygon createEllipse() {
        Object object = this.dim.getEnvelope();
        double d = object.getWidth() / 2.0;
        double d2 = object.getHeight() / 2.0;
        double d3 = object.getMinX();
        double d4 = object.getMinY();
        object = new Coordinate[this.nPts + 1];
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if (n >= (n3 = this.nPts)) {
                object[n2] = new Coordinate(object[0]);
                object = this.geomFact.createLinearRing((Coordinate[])object);
                return (Polygon)this.rotate(this.geomFact.createPolygon((LinearRing)object, null));
            }
            double d5 = (double)n * (Math.PI * 2 / (double)n3);
            object[n2] = this.coord(Math.cos(d5) * d + (d3 + d), Math.sin(d5) * d2 + (d4 + d2));
            ++n;
            ++n2;
        }
    }

    public Polygon createRectangle() {
        int n;
        int n2 = n = this.nPts / 4;
        if (n < 1) {
            n2 = 1;
        }
        double d = this.dim.getEnvelope().getWidth();
        double d2 = n2;
        d /= d2;
        d2 = this.dim.getEnvelope().getHeight() / d2;
        Coordinate[] coordinateArray = new Coordinate[n2 * 4 + 1];
        Comparable comparable = this.dim.getEnvelope();
        int n3 = 0;
        n = 0;
        while (true) {
            if (n3 >= n2) {
                n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        n3 = 0;
                        while (true) {
                            if (n3 >= n2) {
                                n3 = 0;
                                while (true) {
                                    if (n3 >= n2) {
                                        coordinateArray[n] = new Coordinate(coordinateArray[0]);
                                        comparable = this.geomFact.createLinearRing(coordinateArray);
                                        return (Polygon)this.rotate(this.geomFact.createPolygon((LinearRing)comparable, null));
                                    }
                                    coordinateArray[n] = this.coord(comparable.getMinX(), comparable.getMaxY() - (double)n3 * d2);
                                    ++n3;
                                    ++n;
                                }
                            }
                            coordinateArray[n] = this.coord(comparable.getMaxX() - (double)n3 * d, comparable.getMaxY());
                            ++n3;
                            ++n;
                        }
                    }
                    coordinateArray[n] = this.coord(comparable.getMaxX(), comparable.getMinY() + (double)n3 * d2);
                    ++n3;
                    ++n;
                }
            }
            coordinateArray[n] = this.coord(comparable.getMinX() + (double)n3 * d, comparable.getMinY());
            ++n3;
            ++n;
        }
    }

    public Polygon createSquircle() {
        return this.createSupercircle(4.0);
    }

    public Polygon createSupercircle(double d) {
        double d2 = 1.0 / d;
        double d3 = this.dim.getMinSize() / 2.0;
        Coordinate coordinate = this.dim.getCentre();
        double d4 = Math.pow(d3, d);
        double d5 = Math.pow(d4 / 2.0, d2);
        int n = this.nPts / 8;
        int n2 = n * 8;
        int n3 = n2 + 1;
        Object object = new Coordinate[n3];
        double d6 = d5 / (double)n;
        int n4 = 0;
        while (true) {
            double d7;
            if (n4 > n) {
                object[n3 - 1] = new Coordinate(object[0]);
                object = this.geomFact.createLinearRing((Coordinate[])object);
                return (Polygon)this.rotate(this.geomFact.createPolygon((LinearRing)object, null));
            }
            if (n4 != 0) {
                d5 = (double)n4 * d6;
                d7 = Math.pow(d4 - Math.pow(d5, d), d2);
            } else {
                d5 = 0.0;
                d7 = d3;
            }
            object[n4] = this.coordTrans(d5, d7, coordinate);
            int n5 = n * 2;
            object[n5 - n4] = this.coordTrans(d7, d5, coordinate);
            double d8 = -d5;
            object[n5 + n4] = this.coordTrans(d7, d8, coordinate);
            n5 = n * 4;
            double d9 = -d7;
            object[n5 - n4] = this.coordTrans(d5, d9, coordinate);
            object[n5 + n4] = this.coordTrans(d8, d9, coordinate);
            n5 = n * 6;
            object[n5 - n4] = this.coordTrans(d9, d8, coordinate);
            object[n5 + n4] = this.coordTrans(d9, d5, coordinate);
            object[n2 - n4] = this.coordTrans(d8, d7, coordinate);
            ++n4;
        }
    }

    protected Geometry rotate(Geometry geometry) {
        double d = this.rotationAngle;
        if (d != 0.0) {
            geometry.apply(AffineTransformation.rotationInstance(d, this.dim.getCentre().x, this.dim.getCentre().y));
        }
        return geometry;
    }

    public void setBase(Coordinate coordinate) {
        this.dim.setBase(coordinate);
    }

    public void setCentre(Coordinate coordinate) {
        this.dim.setCentre(coordinate);
    }

    public void setEnvelope(Envelope envelope) {
        this.dim.setEnvelope(envelope);
    }

    public void setHeight(double d) {
        this.dim.setHeight(d);
    }

    public void setNumPoints(int n) {
        this.nPts = n;
    }

    public void setRotation(double d) {
        this.rotationAngle = d;
    }

    public void setSize(double d) {
        this.dim.setSize(d);
    }

    public void setWidth(double d) {
        this.dim.setWidth(d);
    }

    protected class Dimensions {
        public Coordinate base;
        public Coordinate centre;
        public double height;
        public double width;

        protected Dimensions() {
        }

        public Coordinate getBase() {
            return this.base;
        }

        public Coordinate getCentre() {
            if (this.centre == null) {
                this.centre = new Coordinate(this.base.x + this.width / 2.0, this.base.y + this.height / 2.0);
            }
            return this.centre;
        }

        public Envelope getEnvelope() {
            Coordinate coordinate = this.base;
            if (coordinate != null) {
                double d = coordinate.x;
                double d2 = this.base.x;
                double d3 = this.width;
                double d4 = this.base.y;
                double d5 = this.base.y;
                return new Envelope(d, d3 + d2, d4, this.height + d5);
            }
            coordinate = this.centre;
            if (coordinate != null) {
                double d = coordinate.x;
                double d6 = this.width / 2.0;
                double d7 = this.centre.x;
                double d8 = this.width / 2.0;
                double d9 = this.centre.y;
                double d10 = this.height / 2.0;
                double d11 = this.centre.y;
                return new Envelope(d - d6, d8 + d7, d9 - d10, this.height / 2.0 + d11);
            }
            return new Envelope(0.0, this.width, 0.0, this.height);
        }

        public double getHeight() {
            return this.height;
        }

        public double getMinSize() {
            return Math.min(this.width, this.height);
        }

        public double getWidth() {
            return this.width;
        }

        public void setBase(Coordinate coordinate) {
            this.base = coordinate;
        }

        public void setCentre(Coordinate coordinate) {
            this.centre = coordinate;
        }

        public void setEnvelope(Envelope envelope) {
            this.width = envelope.getWidth();
            this.height = envelope.getHeight();
            this.base = new Coordinate(envelope.getMinX(), envelope.getMinY());
            this.centre = new Coordinate(envelope.centre());
        }

        public void setHeight(double d) {
            this.height = d;
        }

        public void setSize(double d) {
            this.height = d;
            this.width = d;
        }

        public void setWidth(double d) {
            this.width = d;
        }
    }
}

