/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

public class Memory {
    public static final double GB = 1.073741824E9;
    public static final double KB = 1024.0;
    public static final double MB = 1048576.0;

    public static String allString() {
        StringBuilder stringBuilder = new StringBuilder("Used: ");
        stringBuilder.append(Memory.usedString());
        stringBuilder.append("   Free: ");
        stringBuilder.append(Memory.freeString());
        stringBuilder.append("   Total: ");
        stringBuilder.append(Memory.totalString());
        return stringBuilder.toString();
    }

    public static String format(long l) {
        double d = l;
        if (d < 2048.0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(l));
            stringBuilder.append(" bytes");
            return stringBuilder.toString();
        }
        if (d < 2097152.0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Memory.round(d / 1024.0)));
            stringBuilder.append(" KB");
            return stringBuilder.toString();
        }
        if (d < 2.147483648E9) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Memory.round(d / 1048576.0)));
            stringBuilder.append(" MB");
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Memory.round(d / 1.073741824E9)));
        stringBuilder.append(" GB");
        return stringBuilder.toString();
    }

    public static long free() {
        return Runtime.getRuntime().freeMemory();
    }

    public static String freeString() {
        return Memory.format(Memory.free());
    }

    public static double round(double d) {
        return Math.ceil(d * 100.0) / 100.0;
    }

    public static long total() {
        return Runtime.getRuntime().totalMemory();
    }

    public static String totalString() {
        return Memory.format(Memory.total());
    }

    public static long used() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static String usedString() {
        return Memory.format(Memory.used());
    }

    public static String usedTotalString() {
        StringBuilder stringBuilder = new StringBuilder("Used: ");
        stringBuilder.append(Memory.usedString());
        stringBuilder.append("   Total: ");
        stringBuilder.append(Memory.totalString());
        return stringBuilder.toString();
    }
}

