/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

public class StringUtil {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static NumberFormat SIMPLE_ORDINATE_FORMAT = new DecimalFormat("0.#");

    public static String chars(char c, int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray);
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        return byteArrayOutputStream.toString();
    }

    public static String getStackTrace(Throwable object, int n) {
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(StringUtil.getStackTrace((Throwable)object)));
        object = "";
        int n2 = 0;
        while (n2 < n) {
            try {
                CharSequence charSequence = new StringBuilder(String.valueOf(object));
                charSequence.append(lineNumberReader.readLine());
                charSequence.append(NEWLINE);
                charSequence = charSequence.toString();
                object = charSequence;
            }
            catch (IOException iOException) {
                Assert.shouldNeverReachHere();
            }
            ++n2;
        }
        return object;
    }

    public static String spaces(int n) {
        return StringUtil.chars(' ', n);
    }

    public static String[] split(String stringArray, String string2) {
        int n = string2.length();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)stringArray);
        stringArray = stringBuilder.toString();
        int n2 = stringArray.indexOf(string2);
        while (true) {
            int n3 = 0;
            if (n2 < 0) {
                if (stringArray.length() > 0) {
                    arrayList.add(stringArray);
                }
                n = arrayList.size();
                stringArray = new String[n];
                n2 = n3;
                while (true) {
                    if (n2 >= n) {
                        return stringArray;
                    }
                    stringArray[n2] = (String)arrayList.get(n2);
                    ++n2;
                }
            }
            arrayList.add(stringArray.substring(0, n2));
            stringArray = stringArray.substring(n2 + n);
            n2 = stringArray.indexOf(string2);
        }
    }

    public static String toString(double d) {
        return SIMPLE_ORDINATE_FORMAT.format(d);
    }
}

