/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.HciStatus;
import com.welie.blessed.Logger;
import com.welie.blessed.PeripheralType;
import com.welie.blessed.ScanFailure;
import com.welie.blessed.ScanMode;
import com.welie.blessed.Transport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class BluetoothCentralManager {
    private static final String CANNOT_CONNECT_TO_PERIPHERAL_BECAUSE_BLUETOOTH_IS_OFF = "cannot connect to peripheral because Bluetooth is off";
    private static final Transport DEFAULT_TRANSPORT = Transport.LE;
    private static final int MAX_CONNECTION_RETRIES = 1;
    private static final String NO_PERIPHERAL_ADDRESS_PROVIDED = "no peripheral address provided";
    private static final String NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED = "no valid peripheral callback specified";
    private static final String NO_VALID_PERIPHERAL_PROVIDED = "no valid peripheral provided";
    private static final int SCAN_RESTART_DELAY = 1000;
    private static final long SCAN_TIMEOUT = 180000L;
    private static final String TAG = "BluetoothCentralManager";
    protected final BroadcastReceiver adapterStateReceiver;
    private Runnable autoConnectRunnable;
    private final ScanCallback autoConnectScanCallback;
    private final ScanSettings autoConnectScanSettings;
    private BluetoothLeScanner autoConnectScanner;
    private final BluetoothAdapter bluetoothAdapter;
    private final BluetoothCentralManagerCallback bluetoothCentralManagerCallback;
    private BluetoothLeScanner bluetoothScanner;
    private final Handler callBackHandler;
    private final Object connectLock;
    private final Map<String, BluetoothPeripheral> connectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    private final Map<String, Integer> connectionRetries;
    private final Context context;
    private ScanCallback currentCallback;
    private List<ScanFilter> currentFilters;
    private final ScanCallback defaultScanCallback;
    private Runnable disconnectRunnable;
    private boolean expectingBluetoothOffDisconnects = false;
    protected final BluetoothPeripheral.InternalCallback internalCallback;
    private final Handler mainHandler;
    private final Map<String, String> pinCodes;
    private final Map<String, BluetoothPeripheralCallback> reconnectCallbacks;
    private final List<String> reconnectPeripheralAddresses;
    private final ScanCallback scanByNameCallback;
    private String[] scanPeripheralNames;
    private ScanSettings scanSettings;
    private final Map<String, BluetoothPeripheral> scannedPeripherals;
    private Runnable timeoutRunnable;
    private Transport transport;
    private final Map<String, BluetoothPeripheral> unconnectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();

    public BluetoothCentralManager(Context context, BluetoothCentralManagerCallback bluetoothCentralManagerCallback, Handler handler) {
        BroadcastReceiver broadcastReceiver;
        this.scannedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
        this.reconnectPeripheralAddresses = new ArrayList<String>();
        this.reconnectCallbacks = new ConcurrentHashMap<String, BluetoothPeripheralCallback>();
        this.scanPeripheralNames = new String[0];
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.connectLock = new Object();
        this.connectionRetries = new ConcurrentHashMap<String, Integer>();
        this.pinCodes = new ConcurrentHashMap<String, String>();
        this.transport = DEFAULT_TRANSPORT;
        this.scanByNameCallback = new ScanCallback(){

            public void onScanFailed(int n) {
                BluetoothCentralManager.this.stopScan();
                BluetoothCentralManager.this.sendScanFailed(ScanFailure.fromValue(n));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onScanResult(int n, ScanResult scanResult) {
                synchronized (this) {
                    String string2 = scanResult.getDevice().getName();
                    if (string2 == null) {
                        return;
                    }
                    String[] stringArray = BluetoothCentralManager.this.scanPeripheralNames;
                    int n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        if (string2.contains(stringArray[n])) {
                            BluetoothCentralManager.this.sendScanResult(scanResult);
                            return;
                        }
                        ++n;
                    }
                    return;
                }
            }
        };
        this.defaultScanCallback = new ScanCallback(){

            public void onScanFailed(int n) {
                BluetoothCentralManager.this.stopScan();
                BluetoothCentralManager.this.sendScanFailed(ScanFailure.fromValue(n));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onScanResult(int n, ScanResult scanResult) {
                synchronized (this) {
                    BluetoothCentralManager.this.sendScanResult(scanResult);
                    return;
                }
            }
        };
        this.autoConnectScanCallback = new ScanCallback(){

            public void onScanFailed(int n) {
                final ScanFailure scanFailure = ScanFailure.fromValue(n);
                Logger.e(TAG, "autoConnect scan failed with error code %d (%s)", new Object[]{n, scanFailure});
                BluetoothCentralManager.this.stopAutoconnectScan();
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onScanFailed(scanFailure);
                    }
                });
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onScanResult(int n, ScanResult object) {
                synchronized (this) {
                    if (!BluetoothCentralManager.this.isAutoScanning()) {
                        return;
                    }
                    Logger.d(TAG, "peripheral with address '%s' found", object.getDevice().getAddress());
                    BluetoothCentralManager.this.stopAutoconnectScan();
                    String string2 = object.getDevice().getAddress();
                    BluetoothPeripheral bluetoothPeripheral = (BluetoothPeripheral)BluetoothCentralManager.this.unconnectedPeripherals.get(string2);
                    object = (BluetoothPeripheralCallback)BluetoothCentralManager.this.reconnectCallbacks.get(string2);
                    BluetoothCentralManager.this.reconnectPeripheralAddresses.remove(string2);
                    BluetoothCentralManager.this.reconnectCallbacks.remove(string2);
                    BluetoothCentralManager.this.removePeripheralFromCaches(string2);
                    if (bluetoothPeripheral != null && object != null) {
                        BluetoothCentralManager.this.connectPeripheral(bluetoothPeripheral, (BluetoothPeripheralCallback)object);
                    }
                    if (BluetoothCentralManager.this.reconnectPeripheralAddresses.size() > 0) {
                        BluetoothCentralManager.this.scanForAutoConnectPeripherals();
                    }
                    return;
                }
            }
        };
        this.internalCallback = new BluetoothPeripheral.InternalCallback(){

            @Override
            public void connectFailed(final BluetoothPeripheral bluetoothPeripheral, final HciStatus hciStatus) {
                String string2 = bluetoothPeripheral.getAddress();
                Integer n = (Integer)BluetoothCentralManager.this.connectionRetries.get(string2);
                int n2 = n != null ? n : 0;
                BluetoothCentralManager.this.removePeripheralFromCaches(string2);
                if (n2 < 1 && hciStatus != HciStatus.CONNECTION_FAILED_ESTABLISHMENT) {
                    Logger.i(TAG, "retrying connection to '%s' (%s)", bluetoothPeripheral.getName(), string2);
                    BluetoothCentralManager.this.connectionRetries.put(string2, n2 + 1);
                    BluetoothCentralManager.this.unconnectedPeripherals.put(string2, bluetoothPeripheral);
                    bluetoothPeripheral.connect();
                } else {
                    Logger.i(TAG, "connection to '%s' (%s) failed", bluetoothPeripheral.getName(), string2);
                    BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectionFailed(bluetoothPeripheral, hciStatus);
                        }
                    });
                }
            }

            @Override
            public void connected(final BluetoothPeripheral bluetoothPeripheral) {
                String string2 = bluetoothPeripheral.getAddress();
                BluetoothCentralManager.this.removePeripheralFromCaches(string2);
                BluetoothCentralManager.this.connectedPeripherals.put(string2, bluetoothPeripheral);
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectedPeripheral(bluetoothPeripheral);
                    }
                });
            }

            @Override
            public void connecting(final BluetoothPeripheral bluetoothPeripheral) {
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectingPeripheral(bluetoothPeripheral);
                    }
                });
            }

            @Override
            public void disconnected(final BluetoothPeripheral bluetoothPeripheral, final HciStatus hciStatus) {
                if (BluetoothCentralManager.this.expectingBluetoothOffDisconnects) {
                    BluetoothCentralManager.this.cancelDisconnectionTimer();
                    BluetoothCentralManager.access$1602(BluetoothCentralManager.this, false);
                }
                BluetoothCentralManager.this.removePeripheralFromCaches(bluetoothPeripheral.getAddress());
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectedPeripheral(bluetoothPeripheral, hciStatus);
                    }
                });
            }

            @Override
            public void disconnecting(final BluetoothPeripheral bluetoothPeripheral) {
                BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectingPeripheral(bluetoothPeripheral);
                    }
                });
            }

            @Override
            public String getPincode(BluetoothPeripheral bluetoothPeripheral) {
                return (String)BluetoothCentralManager.this.pinCodes.get(bluetoothPeripheral.getAddress());
            }
        };
        this.adapterStateReceiver = broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                object = intent.getAction();
                if (object == null) {
                    return;
                }
                if (((String)object).equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                    final int n = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                    BluetoothCentralManager.this.handleAdapterState(n);
                    BluetoothCentralManager.this.callBackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothCentralManager.this.bluetoothCentralManagerCallback.onBluetoothAdapterStateChanged(n);
                        }
                    });
                }
            }
        };
        Objects.requireNonNull(context, "no valid context provided");
        Object object = context;
        this.context = context;
        Objects.requireNonNull(bluetoothCentralManagerCallback, "no valid bluetoothCallback provided");
        object = bluetoothCentralManagerCallback;
        this.bluetoothCentralManagerCallback = bluetoothCentralManagerCallback;
        Objects.requireNonNull(handler, "no valid handler provided");
        bluetoothCentralManagerCallback = handler;
        this.callBackHandler = handler;
        handler = (BluetoothManager)context.getSystemService("bluetooth");
        Objects.requireNonNull(handler, "cannot get BluetoothManager");
        bluetoothCentralManagerCallback = (BluetoothManager)handler;
        bluetoothCentralManagerCallback = handler.getAdapter();
        Objects.requireNonNull(bluetoothCentralManagerCallback, "no bluetooth adapter found");
        handler = (BluetoothAdapter)bluetoothCentralManagerCallback;
        this.bluetoothAdapter = bluetoothCentralManagerCallback;
        this.autoConnectScanSettings = this.getScanSettings(ScanMode.LOW_POWER);
        this.scanSettings = this.getScanSettings(ScanMode.LOW_LATENCY);
        context.registerReceiver(broadcastReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
    }

    static /* synthetic */ boolean access$1602(BluetoothCentralManager bluetoothCentralManager, boolean bl) {
        bluetoothCentralManager.expectingBluetoothOffDisconnects = bl;
        return bl;
    }

    static /* synthetic */ BluetoothLeScanner access$2302(BluetoothCentralManager bluetoothCentralManager, BluetoothLeScanner bluetoothLeScanner) {
        bluetoothCentralManager.autoConnectScanner = bluetoothLeScanner;
        return bluetoothLeScanner;
    }

    static /* synthetic */ Runnable access$2702(BluetoothCentralManager bluetoothCentralManager, Runnable runnable) {
        bluetoothCentralManager.disconnectRunnable = runnable;
        return runnable;
    }

    private void autoConnectPeripheralByScan(String string2, BluetoothPeripheralCallback bluetoothPeripheralCallback) {
        if (this.reconnectPeripheralAddresses.contains(string2)) {
            Logger.w(TAG, "peripheral already on list for reconnection");
            return;
        }
        this.reconnectPeripheralAddresses.add(string2);
        this.reconnectCallbacks.put(string2, bluetoothPeripheralCallback);
        this.scanForAutoConnectPeripherals();
    }

    private boolean bleNotReady() {
        if (this.isBleSupported() && this.isBluetoothEnabled()) {
            return this.permissionsGranted() ^ true;
        }
        return true;
    }

    private void cancelAllConnectionsWhenBluetoothOff() {
        Logger.d(TAG, "disconnect all peripherals because bluetooth is off");
        Iterator<BluetoothPeripheral> iterator2 = this.connectedPeripherals.values().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().disconnectWhenBluetoothOff();
        }
        this.connectedPeripherals.clear();
        iterator2 = this.unconnectedPeripherals.values().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().disconnectWhenBluetoothOff();
        }
        this.unconnectedPeripherals.clear();
        this.reconnectPeripheralAddresses.clear();
        this.reconnectCallbacks.clear();
    }

    private void cancelAutoConnectTimer() {
        Runnable runnable = this.autoConnectRunnable;
        if (runnable != null) {
            this.mainHandler.removeCallbacks(runnable);
            this.autoConnectRunnable = null;
        }
    }

    private void cancelDisconnectionTimer() {
        Runnable runnable = this.disconnectRunnable;
        if (runnable != null) {
            this.mainHandler.removeCallbacks(runnable);
            this.disconnectRunnable = null;
        }
    }

    private void cancelTimeoutTimer() {
        Runnable runnable = this.timeoutRunnable;
        if (runnable != null) {
            this.mainHandler.removeCallbacks(runnable);
            this.timeoutRunnable = null;
        }
    }

    private ScanSettings getScanSettings(ScanMode scanMode) {
        Objects.requireNonNull(scanMode, "scanMode is null");
        if (Build.VERSION.SDK_INT >= 23) {
            return new ScanSettings.Builder().setScanMode(scanMode.value).setCallbackType(1).setMatchMode(1).setNumOfMatches(1).setReportDelay(0L).build();
        }
        return new ScanSettings.Builder().setScanMode(scanMode.value).setReportDelay(0L).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleAdapterState(int n) {
        block13: {
            switch (n) {
                default: {
                    return;
                }
                case 13: {
                    if (this.isScanning()) {
                        try {
                            this.stopScan();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.isAutoScanning()) break block13;
                    this.stopAutoconnectScan();
                    break block13;
                }
                case 12: {
                    BluetoothLeScanner bluetoothLeScanner;
                    Logger.d(TAG, "bluetooth turned on");
                    this.bluetoothScanner = bluetoothLeScanner = this.bluetoothAdapter.getBluetoothLeScanner();
                    if (bluetoothLeScanner != null) {
                        bluetoothLeScanner.stopScan(this.defaultScanCallback);
                    }
                    this.expectingBluetoothOffDisconnects = false;
                    return;
                }
                case 11: {
                    this.expectingBluetoothOffDisconnects = false;
                    Logger.d(TAG, "bluetooth turning on");
                    return;
                }
                case 10: {
                    if (this.connectedPeripherals.size() > 0 || this.unconnectedPeripherals.size() > 0) {
                        this.expectingBluetoothOffDisconnects = true;
                        this.startDisconnectionTimer();
                    }
                    Logger.d(TAG, "bluetooth turned off");
                    return;
                }
            }
            catch (Exception exception) {}
        }
        this.expectingBluetoothOffDisconnects = true;
        this.cancelTimeoutTimer();
        this.cancelAutoConnectTimer();
        this.currentCallback = null;
        this.currentFilters = null;
        this.autoConnectScanner = null;
        this.bluetoothScanner = null;
        Logger.d(TAG, "bluetooth turning off");
    }

    private boolean isAutoScanning() {
        boolean bl = this.autoConnectScanner != null;
        return bl;
    }

    private boolean isBleSupported() {
        if (this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return true;
        }
        Logger.e(TAG, "BLE not supported");
        return false;
    }

    private boolean permissionsGranted() {
        int n = this.context.getApplicationInfo().targetSdkVersion;
        if (Build.VERSION.SDK_INT >= 31 && n >= 31) {
            if (this.context.checkSelfPermission("android.permission.BLUETOOTH_SCAN") == 0) {
                if (this.context.checkSelfPermission("android.permission.BLUETOOTH_CONNECT") == 0) {
                    return true;
                }
                throw new SecurityException("app does not have BLUETOOTH_CONNECT permission, cannot connect");
            }
            throw new SecurityException("app does not have BLUETOOTH_SCAN permission, cannot start scan");
        }
        if (Build.VERSION.SDK_INT >= 29 && n >= 29) {
            if (this.context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0) {
                return true;
            }
            throw new SecurityException("app does not have ACCESS_FINE_LOCATION permission, cannot start scan");
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0) {
                return true;
            }
            throw new SecurityException("app does not have ACCESS_COARSE_LOCATION permission, cannot start scan");
        }
        return true;
    }

    private void removePeripheralFromCaches(String string2) {
        this.connectedPeripherals.remove(string2);
        this.unconnectedPeripherals.remove(string2);
        this.scannedPeripherals.remove(string2);
        this.connectionRetries.remove(string2);
    }

    private void scanForAutoConnectPeripherals() {
        BluetoothLeScanner object2;
        if (this.bleNotReady()) {
            return;
        }
        if (this.autoConnectScanner != null) {
            this.stopAutoconnectScan();
        }
        this.autoConnectScanner = object2 = this.bluetoothAdapter.getBluetoothLeScanner();
        if (object2 != null) {
            ArrayList<ScanFilter> arrayList = new ArrayList<ScanFilter>();
            for (String string2 : this.reconnectPeripheralAddresses) {
                arrayList.add(new ScanFilter.Builder().setDeviceAddress(string2).build());
            }
            this.autoConnectScanner.startScan(arrayList, this.autoConnectScanSettings, this.autoConnectScanCallback);
            String string3 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("started scanning to autoconnect peripherals (");
            stringBuilder.append(this.reconnectPeripheralAddresses.size());
            stringBuilder.append(")");
            Logger.d(string3, stringBuilder.toString());
            this.setAutoConnectTimer();
        } else {
            Logger.e(TAG, "starting autoconnect scan failed");
        }
    }

    private void sendBondedDevices() {
        this.callBackHandler.post(new Runnable(){

            @Override
            public void run() {
                Object object = BluetoothCentralManager.this.bluetoothAdapter.getBondedDevices();
                if (object.size() > 0) {
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        BluetoothDevice bluetoothDevice = (BluetoothDevice)iterator2.next();
                        object = BluetoothCentralManager.this.getPeripheral(bluetoothDevice.getAddress());
                        object = object != null ? ((BluetoothPeripheral)object).getName().toLowerCase(Locale.ROOT) : "";
                        if (!((String)object).contains("rider") && !((String)object).contains("aero")) continue;
                        object = new ScanResult(bluetoothDevice, null, 0, 0L);
                        BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDiscoveredPeripheral(null, (ScanResult)object);
                    }
                }
            }
        });
    }

    private void sendScanFailed(final ScanFailure scanFailure) {
        this.currentCallback = null;
        this.currentFilters = null;
        this.callBackHandler.post(new Runnable(){

            @Override
            public void run() {
                Logger.e(TAG, "scan failed with error code %d (%s)", new Object[]{scanFailure.value, scanFailure});
                BluetoothCentralManager.this.bluetoothCentralManagerCallback.onScanFailed(scanFailure);
            }
        });
    }

    private void sendScanResult(final ScanResult scanResult) {
        this.callBackHandler.post(new Runnable(){

            @Override
            public void run() {
                if (BluetoothCentralManager.this.isScanning()) {
                    BluetoothPeripheral bluetoothPeripheral = BluetoothCentralManager.this.getPeripheral(scanResult.getDevice().getAddress());
                    bluetoothPeripheral.setDevice(scanResult.getDevice());
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDiscoveredPeripheral(bluetoothPeripheral, scanResult);
                }
            }
        });
    }

    private void setAutoConnectTimer() {
        Runnable runnable;
        this.cancelAutoConnectTimer();
        this.autoConnectRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                Logger.d(TAG, "autoconnect scan timeout, restarting scan");
                if (BluetoothCentralManager.this.autoConnectScanner != null) {
                    BluetoothCentralManager.this.autoConnectScanner.stopScan(BluetoothCentralManager.this.autoConnectScanCallback);
                    BluetoothCentralManager.access$2302(BluetoothCentralManager.this, null);
                }
                BluetoothCentralManager.this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentralManager.this.scanForAutoConnectPeripherals();
                    }
                }, 1000L);
            }
        };
        this.mainHandler.postDelayed(runnable, 180000L);
    }

    private void setScanTimer() {
        Runnable runnable;
        this.cancelTimeoutTimer();
        this.timeoutRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                Logger.d(TAG, "scanning timeout, restarting scan");
                final ScanCallback scanCallback = BluetoothCentralManager.this.currentCallback;
                final List list = BluetoothCentralManager.this.currentFilters;
                BluetoothCentralManager.this.stopScan();
                BluetoothCentralManager.this.callBackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (scanCallback != null) {
                            BluetoothCentralManager.this.startScan(list, BluetoothCentralManager.this.scanSettings, scanCallback);
                        }
                    }
                }, 1000L);
            }
        };
        this.mainHandler.postDelayed(runnable, 180000L);
    }

    private void startDisconnectionTimer() {
        Runnable runnable;
        this.cancelDisconnectionTimer();
        this.disconnectRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                Logger.e(TAG, "bluetooth turned off but no automatic disconnects happening, so doing it ourselves");
                BluetoothCentralManager.this.cancelAllConnectionsWhenBluetoothOff();
                BluetoothCentralManager.access$2702(BluetoothCentralManager.this, null);
            }
        };
        this.mainHandler.postDelayed(runnable, 1000L);
    }

    private void startScan(List<ScanFilter> list, ScanSettings scanSettings, ScanCallback scanCallback) {
        if (this.bleNotReady()) {
            return;
        }
        if (this.isScanning()) {
            Logger.e(TAG, "other scan still active, stopping scan");
            this.stopScan();
        }
        if (this.bluetoothScanner == null) {
            this.bluetoothScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        }
        if (this.bluetoothScanner != null) {
            this.sendBondedDevices();
            this.setScanTimer();
            this.currentCallback = scanCallback;
            this.currentFilters = list;
            this.bluetoothScanner.startScan(list, scanSettings, scanCallback);
            Logger.i(TAG, "scan started");
        } else {
            Logger.e(TAG, "starting scan failed");
        }
    }

    private void stopAutoconnectScan() {
        this.cancelAutoConnectTimer();
        BluetoothLeScanner bluetoothLeScanner = this.autoConnectScanner;
        if (bluetoothLeScanner != null) {
            bluetoothLeScanner.stopScan(this.autoConnectScanCallback);
            this.autoConnectScanner = null;
            Logger.i(TAG, "autoscan stopped");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void autoConnectPeripheral(BluetoothPeripheral bluetoothPeripheral, BluetoothPeripheralCallback bluetoothPeripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            Objects.requireNonNull(bluetoothPeripheral, NO_VALID_PERIPHERAL_PROVIDED);
            Objects.requireNonNull(bluetoothPeripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED);
            if (this.connectedPeripherals.containsKey(bluetoothPeripheral.getAddress())) {
                Logger.w(TAG, "already connected to %s'", bluetoothPeripheral.getAddress());
                return;
            }
            if (this.unconnectedPeripherals.get(bluetoothPeripheral.getAddress()) != null) {
                Logger.w(TAG, "already issued autoconnect for '%s' ", bluetoothPeripheral.getAddress());
                return;
            }
            if (!this.bluetoothAdapter.isEnabled()) {
                Logger.e(TAG, CANNOT_CONNECT_TO_PERIPHERAL_BECAUSE_BLUETOOTH_IS_OFF);
                return;
            }
            if (bluetoothPeripheral.isUncached()) {
                Logger.d(TAG, "peripheral with address '%s' not in Bluetooth cache, autoconnecting by scanning", bluetoothPeripheral.getAddress());
                this.scannedPeripherals.remove(bluetoothPeripheral.getAddress());
                this.unconnectedPeripherals.put(bluetoothPeripheral.getAddress(), bluetoothPeripheral);
                this.autoConnectPeripheralByScan(bluetoothPeripheral.getAddress(), bluetoothPeripheralCallback);
                return;
            }
            if (bluetoothPeripheral.getType() == PeripheralType.CLASSIC) {
                Logger.e(TAG, "peripheral does not support Bluetooth LE");
                return;
            }
            bluetoothPeripheral.setPeripheralCallback(bluetoothPeripheralCallback);
            this.scannedPeripherals.remove(bluetoothPeripheral.getAddress());
            this.unconnectedPeripherals.put(bluetoothPeripheral.getAddress(), bluetoothPeripheral);
            bluetoothPeripheral.autoConnect();
            return;
        }
    }

    public void autoConnectPeripheralsBatch(Map<BluetoothPeripheral, BluetoothPeripheralCallback> object) {
        Objects.requireNonNull(object, "no valid batch provided");
        if (!this.bluetoothAdapter.isEnabled()) {
            Logger.e(TAG, CANNOT_CONNECT_TO_PERIPHERAL_BECAUSE_BLUETOOTH_IS_OFF);
            return;
        }
        HashMap<BluetoothPeripheral, BluetoothPeripheralCallback> hashMap = new HashMap<BluetoothPeripheral, BluetoothPeripheralCallback>();
        for (BluetoothPeripheral bluetoothPeripheral : object.keySet()) {
            if (bluetoothPeripheral.isUncached()) {
                hashMap.put(bluetoothPeripheral, object.get(bluetoothPeripheral));
                continue;
            }
            this.autoConnectPeripheral(bluetoothPeripheral, object.get(bluetoothPeripheral));
        }
        if (!hashMap.isEmpty()) {
            for (BluetoothPeripheral bluetoothPeripheral : hashMap.keySet()) {
                object = bluetoothPeripheral.getAddress();
                this.reconnectPeripheralAddresses.add((String)object);
                this.reconnectCallbacks.put((String)object, (BluetoothPeripheralCallback)hashMap.get(bluetoothPeripheral));
                this.unconnectedPeripherals.put((String)object, bluetoothPeripheral);
            }
            this.scanForAutoConnectPeripherals();
        }
    }

    public void cancelConnection(final BluetoothPeripheral bluetoothPeripheral) {
        Objects.requireNonNull(bluetoothPeripheral, NO_VALID_PERIPHERAL_PROVIDED);
        String string2 = bluetoothPeripheral.getAddress();
        if (this.reconnectPeripheralAddresses.contains(string2)) {
            this.reconnectPeripheralAddresses.remove(string2);
            this.reconnectCallbacks.remove(string2);
            this.unconnectedPeripherals.remove(string2);
            this.stopAutoconnectScan();
            Logger.d(TAG, "cancelling autoconnect for %s", string2);
            this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectedPeripheral(bluetoothPeripheral, HciStatus.SUCCESS);
                }
            });
            if (this.reconnectPeripheralAddresses.size() > 0) {
                this.scanForAutoConnectPeripherals();
            }
            return;
        }
        if (!this.unconnectedPeripherals.containsKey(string2) && !this.connectedPeripherals.containsKey(string2)) {
            Logger.e(TAG, "cannot cancel connection to unknown peripheral %s", string2);
        } else {
            bluetoothPeripheral.cancelConnection();
        }
    }

    public void close() {
        this.scannedPeripherals.clear();
        this.unconnectedPeripherals.clear();
        this.connectedPeripherals.clear();
        this.reconnectCallbacks.clear();
        this.reconnectPeripheralAddresses.clear();
        this.connectionRetries.clear();
        this.pinCodes.clear();
        this.context.unregisterReceiver(this.adapterStateReceiver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectPeripheral(BluetoothPeripheral bluetoothPeripheral, BluetoothPeripheralCallback bluetoothPeripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            Objects.requireNonNull(bluetoothPeripheral, NO_VALID_PERIPHERAL_PROVIDED);
            Objects.requireNonNull(bluetoothPeripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED);
            if (this.connectedPeripherals.containsKey(bluetoothPeripheral.getAddress())) {
                Logger.w(TAG, "already connected to %s'", bluetoothPeripheral.getAddress());
                return;
            }
            if (this.unconnectedPeripherals.containsKey(bluetoothPeripheral.getAddress())) {
                Logger.w(TAG, "already connecting to %s'", bluetoothPeripheral.getAddress());
                return;
            }
            if (!this.bluetoothAdapter.isEnabled()) {
                Logger.e(TAG, CANNOT_CONNECT_TO_PERIPHERAL_BECAUSE_BLUETOOTH_IS_OFF);
                return;
            }
            if (bluetoothPeripheral.isUncached()) {
                Logger.w(TAG, "peripheral with address '%s' is not in the Bluetooth cache, hence connection may fail", bluetoothPeripheral.getAddress());
            }
            bluetoothPeripheral.setPeripheralCallback(bluetoothPeripheralCallback);
            this.scannedPeripherals.remove(bluetoothPeripheral.getAddress());
            this.unconnectedPeripherals.put(bluetoothPeripheral.getAddress(), bluetoothPeripheral);
            bluetoothPeripheral.connect();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createBond(BluetoothPeripheral bluetoothPeripheral, BluetoothPeripheralCallback bluetoothPeripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            Objects.requireNonNull(bluetoothPeripheral, NO_VALID_PERIPHERAL_PROVIDED);
            Objects.requireNonNull(bluetoothPeripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_SPECIFIED);
            if (this.connectedPeripherals.containsKey(bluetoothPeripheral.getAddress())) {
                Logger.w(TAG, "already connected to %s'", bluetoothPeripheral.getAddress());
                return;
            }
            if (this.unconnectedPeripherals.containsKey(bluetoothPeripheral.getAddress())) {
                Logger.w(TAG, "already connecting to %s'", bluetoothPeripheral.getAddress());
                return;
            }
            if (!this.bluetoothAdapter.isEnabled()) {
                Logger.e(TAG, CANNOT_CONNECT_TO_PERIPHERAL_BECAUSE_BLUETOOTH_IS_OFF);
                return;
            }
            if (bluetoothPeripheral.isUncached()) {
                Logger.w(TAG, "peripheral with address '%s' is not in the Bluetooth cache, hence connection may fail", bluetoothPeripheral.getAddress());
            }
            bluetoothPeripheral.setPeripheralCallback(bluetoothPeripheralCallback);
            bluetoothPeripheral.createBond();
            return;
        }
    }

    public void disableLogging() {
        Logger.enabled = false;
    }

    public void enableLogging() {
        Logger.enabled = true;
    }

    public List<BluetoothPeripheral> getConnectedPeripherals() {
        return new ArrayList<BluetoothPeripheral>(this.connectedPeripherals.values());
    }

    public BluetoothPeripheral getPeripheral(String object) {
        Objects.requireNonNull(object, NO_PERIPHERAL_ADDRESS_PROVIDED);
        if (BluetoothAdapter.checkBluetoothAddress((String)object)) {
            if (this.connectedPeripherals.containsKey(object)) {
                object = this.connectedPeripherals.get(object);
                Objects.requireNonNull(object);
                return (BluetoothPeripheral)object;
            }
            if (this.unconnectedPeripherals.containsKey(object)) {
                object = this.unconnectedPeripherals.get(object);
                Objects.requireNonNull(object);
                return (BluetoothPeripheral)object;
            }
            if (this.scannedPeripherals.containsKey(object)) {
                object = this.scannedPeripherals.get(object);
                Objects.requireNonNull(object);
                return (BluetoothPeripheral)object;
            }
            BluetoothPeripheral bluetoothPeripheral = new BluetoothPeripheral(this.context, this.bluetoothAdapter.getRemoteDevice((String)object), this.internalCallback, new BluetoothPeripheralCallback.NULL(), this.callBackHandler, this.transport);
            this.scannedPeripherals.put((String)object, bluetoothPeripheral);
            return bluetoothPeripheral;
        }
        throw new IllegalArgumentException(String.format("%s is not a valid bluetooth address. Make sure all alphabetic characters are uppercase.", object));
    }

    public Transport getTransport() {
        return this.transport;
    }

    public boolean isBluetoothEnabled() {
        if (this.bluetoothAdapter.isEnabled()) {
            return true;
        }
        Logger.e(TAG, "Bluetooth disabled");
        return false;
    }

    public boolean isScanning() {
        boolean bl = this.bluetoothScanner != null && this.currentCallback != null;
        return bl;
    }

    public boolean removeBond(String object) {
        Objects.requireNonNull(object, NO_PERIPHERAL_ADDRESS_PROVIDED);
        Class[] classArray = this.bluetoothAdapter.getBondedDevices();
        if (classArray.size() > 0) {
            Object[] objectArray;
            Iterator iterator2 = classArray.iterator();
            classArray = null;
            while (iterator2.hasNext()) {
                objectArray = (Class[])iterator2.next();
                if (!objectArray.getAddress().equals(object)) continue;
                classArray = objectArray;
            }
            if (classArray != null) {
                boolean bl;
                block6: {
                    try {
                        object = classArray.getClass();
                        objectArray = null;
                        object = ((Class)object).getMethod("removeBond", null);
                        objectArray = null;
                        bl = (Boolean)((Method)object).invoke((Object)classArray, null);
                        if (!bl) break block6;
                    }
                    catch (Exception exception) {
                        Logger.i(TAG, "could not remove bond");
                        exception.printStackTrace();
                        return false;
                    }
                    Logger.i(TAG, "Succesfully removed bond for '%s'", classArray.getName());
                }
                return bl;
            }
        }
        return true;
    }

    public void scanForPeripherals() {
        this.startScan(Collections.<ScanFilter>emptyList(), this.scanSettings, this.defaultScanCallback);
    }

    public void scanForPeripheralsUsingFilters(List<ScanFilter> list) {
        Objects.requireNonNull(list, "no filters supplied");
        if (!list.isEmpty()) {
            this.startScan(list, this.scanSettings, this.defaultScanCallback);
            return;
        }
        throw new IllegalArgumentException("at least one scan filter must be supplied");
    }

    public void scanForPeripheralsWithAddresses(String[] stringArray) {
        Objects.requireNonNull(stringArray, "no peripheral addresses supplied");
        if (stringArray.length != 0) {
            ArrayList<ScanFilter> arrayList = new ArrayList<ScanFilter>();
            for (String string2 : stringArray) {
                if (BluetoothAdapter.checkBluetoothAddress((String)string2)) {
                    arrayList.add(new ScanFilter.Builder().setDeviceAddress(string2).build());
                    continue;
                }
                Logger.e(TAG, "%s is not a valid address. Make sure all alphabetic characters are uppercase.", string2);
            }
            this.startScan(arrayList, this.scanSettings, this.defaultScanCallback);
            return;
        }
        throw new IllegalArgumentException("at least one peripheral address must be supplied");
    }

    public void scanForPeripheralsWithNames(String[] stringArray) {
        Objects.requireNonNull(stringArray, "no peripheral names supplied");
        if (stringArray.length != 0) {
            this.scanPeripheralNames = stringArray;
            this.startScan(Collections.<ScanFilter>emptyList(), this.scanSettings, this.scanByNameCallback);
            return;
        }
        throw new IllegalArgumentException("at least one peripheral name must be supplied");
    }

    public void scanForPeripheralsWithServices(UUID[] uUIDArray) {
        Objects.requireNonNull(uUIDArray, "no service UUIDs supplied");
        if (uUIDArray.length != 0) {
            ArrayList<ScanFilter> arrayList = new ArrayList<ScanFilter>();
            for (UUID uUID : uUIDArray) {
                arrayList.add(new ScanFilter.Builder().setServiceUuid(new ParcelUuid(uUID)).build());
            }
            this.startScan(arrayList, this.scanSettings, this.defaultScanCallback);
            return;
        }
        throw new IllegalArgumentException("at least one service UUID  must be supplied");
    }

    public boolean setPinCodeForPeripheral(String string2, String string3) {
        Objects.requireNonNull(string2, NO_PERIPHERAL_ADDRESS_PROVIDED);
        Objects.requireNonNull(string3, "no pin provided");
        if (!BluetoothAdapter.checkBluetoothAddress((String)string2)) {
            Logger.e(TAG, "%s is not a valid address. Make sure all alphabetic characters are uppercase.", string2);
            return false;
        }
        if (string3.length() != 6) {
            Logger.e(TAG, "%s is not 6 digits long", string3);
            return false;
        }
        this.pinCodes.put(string2, string3);
        return true;
    }

    public void setScanMode(ScanMode scanMode) {
        Objects.requireNonNull(scanMode);
        this.scanSettings = this.getScanSettings(scanMode);
    }

    public void setTransport(Transport transport) {
        Objects.requireNonNull(transport, "not a valid transport");
        Transport transport2 = transport;
        this.transport = transport;
    }

    public void startPairingPopupHack() {
        if (!Build.MANUFACTURER.equalsIgnoreCase("samsung")) {
            if (this.bleNotReady()) {
                return;
            }
            this.bluetoothAdapter.startDiscovery();
            this.callBackHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Logger.d(TAG, "popup hack completed");
                    BluetoothCentralManager.this.bluetoothAdapter.cancelDiscovery();
                }
            }, 1000L);
        }
    }

    public void stopScan() {
        this.cancelTimeoutTimer();
        if (this.isScanning()) {
            BluetoothLeScanner bluetoothLeScanner = this.bluetoothScanner;
            if (bluetoothLeScanner != null) {
                bluetoothLeScanner.stopScan(this.currentCallback);
                Logger.i(TAG, "scan stopped");
            }
        } else {
            Logger.i(TAG, "no scan to stop because no scan is running");
        }
        this.currentCallback = null;
        this.currentFilters = null;
        this.bluetoothScanner = null;
        this.scannedPeripherals.clear();
    }
}

