/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt;

import dagger.hilt.internal.GeneratedComponent;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;
import dagger.hilt.internal.TestSingletonComponent;
import javax.annotation.Nonnull;

public final class EntryPoints {
    private static final String EARLY_ENTRY_POINT = "dagger.hilt.android.EarlyEntryPoint";

    private EntryPoints() {
    }

    @Nonnull
    public static <T> T get(Object object, Class<T> clazz) {
        if (object instanceof GeneratedComponent) {
            if (object instanceof TestSingletonComponent) {
                Preconditions.checkState(EntryPoints.hasAnnotationReflection(clazz, EARLY_ENTRY_POINT) ^ true, "Interface, %s, annotated with @EarlyEntryPoint should be called with EarlyEntryPoints.get() rather than EntryPoints.get()", clazz.getCanonicalName());
            }
            return clazz.cast(object);
        }
        if (object instanceof GeneratedComponentManager) {
            return EntryPoints.get(((GeneratedComponentManager)object).generatedComponent(), clazz);
        }
        throw new IllegalStateException(String.format("Given component holder %s does not implement %s or %s", object.getClass(), GeneratedComponent.class, GeneratedComponentManager.class));
    }

    private static boolean hasAnnotationReflection(Class<?> annotationArray, String string2) {
        annotationArray = annotationArray.getAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            if (!annotationArray[i].annotationType().getCanonicalName().contentEquals(string2)) continue;
            return true;
        }
        return false;
    }
}

