/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android;

import android.app.Application;
import android.content.Context;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.EarlyEntryPoint;
import dagger.hilt.android.internal.Contexts;
import dagger.hilt.internal.GeneratedComponentManagerHolder;
import dagger.hilt.internal.Preconditions;
import dagger.hilt.internal.TestSingletonComponentManager;
import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;

public final class EarlyEntryPoints {
    private EarlyEntryPoints() {
    }

    @Nonnull
    public static <T> T get(Context object, Class<T> clazz) {
        Application application = Contexts.getApplication(object.getApplicationContext());
        Preconditions.checkState(application instanceof GeneratedComponentManagerHolder, "Expected application context to implement GeneratedComponentManagerHolder. Check that you're passing in an application context that uses Hilt.", new Object[0]);
        object = ((GeneratedComponentManagerHolder)application).componentManager();
        if (object instanceof TestSingletonComponentManager) {
            Preconditions.checkState(EarlyEntryPoints.hasAnnotationReflection(clazz, EarlyEntryPoint.class), "%s should be called with EntryPoints.get() rather than EarlyEntryPoints.get()", clazz.getCanonicalName());
            return clazz.cast(((TestSingletonComponentManager)object).earlySingletonComponent());
        }
        return EntryPoints.get(application, clazz);
    }

    private static boolean hasAnnotationReflection(Class<?> annotationArray, Class<? extends Annotation> clazz) {
        annotationArray = annotationArray.getAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            if (!annotationArray[i].annotationType().equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

