/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public final class DaggerCollections {
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    private DaggerCollections() {
    }

    private static int calculateInitialCapacity(int n) {
        if (n < 3) {
            return n + 1;
        }
        if (n < 0x40000000) {
            return (int)((float)n / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static boolean hasDuplicates(List<?> list) {
        int n = list.size();
        boolean bl = false;
        if (n < 2) {
            return false;
        }
        HashSet hashSet = new HashSet(list);
        if (list.size() != hashSet.size()) {
            bl = true;
        }
        return bl;
    }

    static <T> HashSet<T> newHashSetWithExpectedSize(int n) {
        return new HashSet(DaggerCollections.calculateInitialCapacity(n));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int n) {
        return new LinkedHashMap(DaggerCollections.calculateInitialCapacity(n));
    }

    public static <T> List<T> presizedList(int n) {
        if (n == 0) {
            return Collections.emptyList();
        }
        return new ArrayList(n);
    }
}

