/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.Reader;
import java.util.Objects;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

public abstract class AbstractScriptEngine
implements ScriptEngine {
    protected ScriptContext context = new SimpleScriptContext();

    public AbstractScriptEngine() {
    }

    public AbstractScriptEngine(Bindings bindings) {
        this();
        Objects.requireNonNull(bindings, "n is null");
        this.context.setBindings(bindings, 100);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(reader, this.getScriptContext(bindings));
    }

    @Override
    public Object eval(String string2) throws ScriptException {
        return this.eval(string2, this.context);
    }

    @Override
    public Object eval(String string2, Bindings bindings) throws ScriptException {
        return this.eval(string2, this.getScriptContext(bindings));
    }

    @Override
    public Object get(String string2) {
        Bindings bindings = this.getBindings(100);
        if (bindings != null) {
            return bindings.get(string2);
        }
        return null;
    }

    @Override
    public Bindings getBindings(int n) {
        if (n == 200) {
            return this.context.getBindings(200);
        }
        if (n == 100) {
            return this.context.getBindings(100);
        }
        throw new IllegalArgumentException("Invalid scope value.");
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    protected ScriptContext getScriptContext(Bindings bindings) {
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        Bindings bindings2 = this.getBindings(200);
        if (bindings2 != null) {
            simpleScriptContext.setBindings(bindings2, 200);
        }
        Objects.requireNonNull(bindings, "Engine scope Bindings may not be null.");
        simpleScriptContext.setBindings(bindings, 100);
        simpleScriptContext.setReader(this.context.getReader());
        simpleScriptContext.setWriter(this.context.getWriter());
        simpleScriptContext.setErrorWriter(this.context.getErrorWriter());
        return simpleScriptContext;
    }

    @Override
    public void put(String string2, Object object) {
        Bindings bindings = this.getBindings(100);
        if (bindings != null) {
            bindings.put(string2, object);
        }
    }

    @Override
    public void setBindings(Bindings bindings, int n) {
        block4: {
            block3: {
                block2: {
                    if (n != 200) break block2;
                    this.context.setBindings(bindings, 200);
                    break block3;
                }
                if (n != 100) break block4;
                this.context.setBindings(bindings, 100);
            }
            return;
        }
        throw new IllegalArgumentException("Invalid scope value.");
    }

    @Override
    public void setContext(ScriptContext scriptContext) {
        Objects.requireNonNull(scriptContext, "null context");
        this.context = scriptContext;
    }
}

