/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public class ScriptEngineManager {
    private static final boolean DEBUG = false;
    private HashSet<ScriptEngineFactory> engineSpis;
    private HashMap<String, ScriptEngineFactory> extensionAssociations;
    private Bindings globalScope;
    private HashMap<String, ScriptEngineFactory> mimeTypeAssociations;
    private HashMap<String, ScriptEngineFactory> nameAssociations;

    public ScriptEngineManager() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.canCallerAccessLoader(classLoader)) {
            this.init(classLoader);
        } else {
            this.init(null);
        }
    }

    public ScriptEngineManager(ClassLoader classLoader) {
        this.init(classLoader);
    }

    private boolean canCallerAccessLoader(ClassLoader classLoader) {
        ClassLoader classLoader2;
        SecurityManager securityManager = System.getSecurityManager();
        if (!(securityManager == null || (classLoader2 = this.getCallerClassLoader()) == null || classLoader == classLoader2 && this.isAncestor(classLoader, classLoader2))) {
            try {
                securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    private ClassLoader getCallerClassLoader() {
        Class clazz = Reflection.getCallerClass((int)3);
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader();
    }

    private void init(final ClassLoader classLoader) {
        this.globalScope = new SimpleBindings();
        this.engineSpis = new HashSet();
        this.nameAssociations = new HashMap();
        this.extensionAssociations = new HashMap();
        this.mimeTypeAssociations = new HashMap();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ScriptEngineManager.this.initEngines(classLoader);
                return null;
            }
        });
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initEngines(ClassLoader var1_1) {
        block8: {
            if (var1_1 == null) ** GOTO lbl5
            try {
                var1_1 = Service.providers(ScriptEngineFactory.class, (ClassLoader)var1_1);
                break block8;
lbl5:
                // 1 sources

                var1_1 = Service.installedProviders(ScriptEngineFactory.class);
            }
            catch (ServiceConfigurationError var1_2) {
                var5_9 = System.err;
                var3_5 = new StringBuilder();
                var3_5.append("Can't find ScriptEngineFactory providers: ");
                var3_5.append(var1_2.getMessage());
                var5_9.println(var3_5.toString());
                return;
            }
        }
        while (true) {
            var2_3 = var1_1.hasNext();
            if (!var2_3) ** GOTO lbl45
            {
                catch (ServiceConfigurationError var5_8) {
                    var3_4 = System.err;
                    var1_1 = new StringBuilder();
                    var1_1.append("ScriptEngineManager providers.hasNext(): ");
                    var1_1.append(var5_8.getMessage());
                    var3_4.println(var1_1.toString());
                    return;
                }
            }
            try {
                var3_4 = (ScriptEngineFactory)var1_1.next();
                this.engineSpis.add((ScriptEngineFactory)var3_4);
            }
            catch (ServiceConfigurationError var4_6) {
                var3_4 = System.err;
                var5_7 = new StringBuilder();
                var5_7.append("ScriptEngineManager providers.next(): ");
                var5_7.append(var4_6.getMessage());
                var3_4.println(var5_7.toString());
                continue;
lbl45:
                // 1 sources

                return;
            }
            break;
        }
    }

    private boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
        ClassLoader classLoader3;
        do {
            if (classLoader == (classLoader3 = classLoader2.getParent())) {
                return true;
            }
            classLoader2 = classLoader3;
        } while (classLoader3 != null);
        return false;
    }

    public Object get(String string2) {
        return this.globalScope.get(string2);
    }

    public Bindings getBindings() {
        return this.globalScope;
    }

    /*
     * Unable to fully structure code
     */
    public ScriptEngine getEngineByExtension(String var1_1) {
        Objects.requireNonNull(var1_1);
        var2_2 = this.extensionAssociations.get(var1_1);
        if (var2_2 != null) {
            var2_2 = var2_2.getScriptEngine();
            var2_2.setBindings(this.getBindings(), 200);
            return var2_2;
        }
lbl9:
        // 3 sources

        while (true) {
            var3_4 = this.engineSpis.iterator();
            block7: while (true) {
                var4_5 = var3_4.hasNext();
                var2_2 = null;
                if (!var4_5) break;
                var5_6 = var3_4.next();
                try {
                    var2_2 = var6_7 = var5_6.getExtensions();
                }
                catch (Exception var6_8) {
                    // empty catch block
                }
                if (var2_2 == null) continue;
                var2_2 = var2_2.iterator();
                while (true) {
                    if (var2_2.hasNext()) ** break;
                    continue block7;
                    if (!var1_1.equals((String)var2_2.next())) continue;
                    try {
                        var6_7 = var5_6.getScriptEngine();
                        var6_7.setBindings(this.getBindings(), 200);
                        return var6_7;
                    }
                    catch (Exception var6_9) {
                        continue;
                    }
                    break;
                }
                break;
            }
            return null;
        }
        catch (Exception var2_3) {
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ScriptEngine getEngineByMimeType(String var1_1) {
        Objects.requireNonNull(var1_1);
        var2_2 = this.mimeTypeAssociations.get(var1_1);
        if (var2_2 != null) {
            var2_2 = var2_2.getScriptEngine();
            var2_2.setBindings(this.getBindings(), 200);
            return var2_2;
        }
lbl9:
        // 3 sources

        while (true) {
            var3_4 = this.engineSpis.iterator();
            block7: while (true) {
                var4_5 = var3_4.hasNext();
                var2_2 = null;
                if (!var4_5) break;
                var5_6 = var3_4.next();
                try {
                    var2_2 = var6_7 = var5_6.getMimeTypes();
                }
                catch (Exception var6_8) {
                    // empty catch block
                }
                if (var2_2 == null) continue;
                var2_2 = var2_2.iterator();
                while (true) {
                    if (var2_2.hasNext()) ** break;
                    continue block7;
                    if (!var1_1.equals((String)var2_2.next())) continue;
                    try {
                        var6_7 = var5_6.getScriptEngine();
                        var6_7.setBindings(this.getBindings(), 200);
                        return var6_7;
                    }
                    catch (Exception var6_9) {
                        continue;
                    }
                    break;
                }
                break;
            }
            return null;
        }
        catch (Exception var2_3) {
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ScriptEngine getEngineByName(String var1_1) {
        Objects.requireNonNull(var1_1);
        var2_2 = this.nameAssociations.get(var1_1);
        if (var2_2 != null) {
            var2_2 = var2_2.getScriptEngine();
            var2_2.setBindings(this.getBindings(), 200);
            return var2_2;
        }
lbl9:
        // 3 sources

        while (true) {
            var3_4 = this.engineSpis.iterator();
            block7: while (true) {
                var4_5 = var3_4.hasNext();
                var2_2 = null;
                if (!var4_5) break;
                var5_6 = var3_4.next();
                try {
                    var2_2 = var6_7 = var5_6.getNames();
                }
                catch (Exception var6_8) {
                    // empty catch block
                }
                if (var2_2 == null) continue;
                var2_2 = var2_2.iterator();
                while (true) {
                    if (var2_2.hasNext()) ** break;
                    continue block7;
                    if (!var1_1.equals((String)var2_2.next())) continue;
                    try {
                        var6_7 = var5_6.getScriptEngine();
                        var6_7.setBindings(this.getBindings(), 200);
                        return var6_7;
                    }
                    catch (Exception var6_9) {
                        continue;
                    }
                    break;
                }
                break;
            }
            return null;
        }
        catch (Exception var2_3) {
            ** continue;
        }
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        ArrayList<ScriptEngineFactory> arrayList = new ArrayList<ScriptEngineFactory>(this.engineSpis.size());
        Iterator<ScriptEngineFactory> iterator2 = this.engineSpis.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void put(String string2, Object object) {
        this.globalScope.put(string2, object);
    }

    public void registerEngineExtension(String string2, ScriptEngineFactory scriptEngineFactory) {
        if (string2 != null && scriptEngineFactory != null) {
            this.extensionAssociations.put(string2, scriptEngineFactory);
            return;
        }
        throw null;
    }

    public void registerEngineMimeType(String string2, ScriptEngineFactory scriptEngineFactory) {
        if (string2 != null && scriptEngineFactory != null) {
            this.mimeTypeAssociations.put(string2, scriptEngineFactory);
            return;
        }
        throw null;
    }

    public void registerEngineName(String string2, ScriptEngineFactory scriptEngineFactory) {
        if (string2 != null && scriptEngineFactory != null) {
            this.nameAssociations.put(string2, scriptEngineFactory);
            return;
        }
        throw null;
    }

    public void setBindings(Bindings bindings) {
        if (bindings != null) {
            this.globalScope = bindings;
            return;
        }
        throw new IllegalArgumentException("Global scope cannot be null.");
    }
}

