/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.script.Bindings;

public class SimpleBindings
implements Bindings {
    private Map<String, Object> map;

    public SimpleBindings() {
        this(new HashMap<String, Object>());
    }

    public SimpleBindings(Map<String, Object> map) {
        Objects.requireNonNull(map);
        this.map = map;
    }

    private void checkKey(Object object) {
        Objects.requireNonNull(object, "key can not be null");
        if (object instanceof String) {
            if (!object.equals("")) {
                return;
            }
            throw new IllegalArgumentException("key can not be empty");
        }
        throw new ClassCastException("key should be a String");
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        this.checkKey(object);
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object get(Object object) {
        this.checkKey(object);
        return this.map.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(String string2, Object object) {
        this.checkKey(string2);
        return this.map.put(string2, object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> object) {
        Objects.requireNonNull(object, "toMerge map is null");
        for (Map.Entry entry : object.entrySet()) {
            String string2 = (String)entry.getKey();
            this.checkKey(string2);
            this.put(string2, entry.getValue());
        }
    }

    @Override
    public Object remove(Object object) {
        this.checkKey(object);
        return this.map.remove(object);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }
}

