/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

public class SimpleScriptContext
implements ScriptContext {
    private static List<Integer> scopes;
    protected Bindings engineScope = new SimpleBindings();
    protected Writer errorWriter;
    protected Bindings globalScope = null;
    protected Reader reader = new InputStreamReader(System.in);
    protected Writer writer = new PrintWriter(System.out, true);

    static {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        scopes = arrayList;
        arrayList.add(100);
        scopes.add(200);
        scopes = Collections.unmodifiableList(scopes);
    }

    public SimpleScriptContext() {
        this.errorWriter = new PrintWriter(System.err, true);
    }

    @Override
    public Object getAttribute(String string2) {
        if (this.engineScope.containsKey(string2)) {
            return this.getAttribute(string2, 100);
        }
        Bindings bindings = this.globalScope;
        if (bindings != null && bindings.containsKey(string2)) {
            return this.getAttribute(string2, 200);
        }
        return null;
    }

    @Override
    public Object getAttribute(String string2, int n) {
        if (n != 100) {
            if (n == 200) {
                Bindings bindings = this.globalScope;
                if (bindings != null) {
                    return bindings.get(string2);
                }
                return null;
            }
            throw new IllegalArgumentException("Illegal scope value.");
        }
        return this.engineScope.get(string2);
    }

    @Override
    public int getAttributesScope(String string2) {
        if (this.engineScope.containsKey(string2)) {
            return 100;
        }
        Bindings bindings = this.globalScope;
        if (bindings != null && bindings.containsKey(string2)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Bindings getBindings(int n) {
        if (n == 100) {
            return this.engineScope;
        }
        if (n == 200) {
            return this.globalScope;
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public List<Integer> getScopes() {
        return scopes;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Object removeAttribute(String string2, int n) {
        if (n != 100) {
            if (n == 200) {
                if (this.getBindings(200) != null) {
                    return this.getBindings(200).remove(string2);
                }
                return null;
            }
            throw new IllegalArgumentException("Illegal scope value.");
        }
        if (this.getBindings(100) != null) {
            return this.getBindings(100).remove(string2);
        }
        return null;
    }

    @Override
    public void setAttribute(String string2, Object object, int n) {
        if (n != 100) {
            if (n == 200) {
                Bindings bindings = this.globalScope;
                if (bindings != null) {
                    bindings.put(string2, object);
                }
                return;
            }
            throw new IllegalArgumentException("Illegal scope value.");
        }
        this.engineScope.put(string2, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBindings(Bindings bindings, int n) {
        if (n != 100) {
            if (n != 200) throw new IllegalArgumentException("Invalid scope value.");
            this.globalScope = bindings;
            return;
        } else {
            Objects.requireNonNull(bindings, "Engine scope cannot be null.");
            this.engineScope = bindings;
        }
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

