/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.Externalizable;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0019\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlin/collections/builders/SerializedCollection;", "Ljava/io/Externalizable;", "()V", "collection", "", "tag", "", "(Ljava/util/Collection;I)V", "readExternal", "", "input", "Ljava/io/ObjectInput;", "readResolve", "", "writeExternal", "output", "Ljava/io/ObjectOutput;", "Companion", "kotlin-stdlib"}, k=1, mv={1, 6, 0}, xi=48)
public final class SerializedCollection
implements Externalizable {
    public static final Companion Companion = new Companion(null);
    private static final long serialVersionUID = 0L;
    public static final int tagList = 0;
    public static final int tagSet = 1;
    private Collection<?> collection;
    private final int tag;

    public SerializedCollection() {
        this(CollectionsKt.emptyList(), 0);
    }

    public SerializedCollection(Collection<?> collection, int n) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this.collection = collection;
        this.tag = n;
    }

    private final Object readResolve() {
        return this.collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void readExternal(ObjectInput object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"input");
        int n = object.readByte();
        int n2 = n & 1;
        if ((n & 0xFFFFFFFE) != 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported flags value: ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append('.');
            throw new InvalidObjectException(((StringBuilder)object).toString());
        }
        int n3 = object.readInt();
        if (n3 < 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Illegal size value: ");
            ((StringBuilder)object).append(n3);
            ((StringBuilder)object).append('.');
            throw new InvalidObjectException(((StringBuilder)object).toString());
        }
        int n4 = 0;
        if (n2 != 0) {
            if (n2 != 1) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Unsupported collection type tag: ");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append('.');
                throw new InvalidObjectException(((StringBuilder)object).toString());
            }
            Set<Object> set = SetsKt.createSetBuilder(n3);
            for (n = 0; n < n3; ++n) {
                set.add(object.readObject());
            }
            object = SetsKt.build(set);
        } else {
            List<Object> list = CollectionsKt.createListBuilder(n3);
            for (n = n4; n < n3; ++n) {
                list.add(object.readObject());
            }
            object = CollectionsKt.build(list);
        }
        this.collection = object;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) {
        Intrinsics.checkNotNullParameter((Object)objectOutput, (String)"output");
        objectOutput.writeByte(this.tag);
        objectOutput.writeInt(this.collection.size());
        Iterator<?> iterator2 = this.collection.iterator();
        while (iterator2.hasNext()) {
            objectOutput.writeObject(iterator2.next());
        }
    }

    @Metadata(d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkotlin/collections/builders/SerializedCollection$Companion;", "", "()V", "serialVersionUID", "", "tagList", "", "tagSet", "kotlin-stdlib"}, k=1, mv={1, 6, 0}, xi=48)
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

